<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="keywords" content="">
	<meta name="author" content="">
	<meta name="robots" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="Topgain">
	
	<meta name="format-detection" content="telephone=no">
	
	<!-- PAGE TITLE HERE -->
	<title>Topgain</title>
	
	<!-- FAVICONS ICON -->
	<link rel="shortcut icon" type="image/png" href="images/favicon-1.png">
	<link href="vendor/jquery-nice-select/css/nice-select-1.css" rel="stylesheet">
	<link href="vendor/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min-1.css" rel="stylesheet">
	<link href="vendor/jquery-autocomplete/jquery-ui-1.css" rel="stylesheet">
	
	<!-- Style css -->
	
    <link href="css/style-1.css" rel="stylesheet">
	
</head>
<body >

    <!--*******************
        Preloader start
    ********************-->

    <!--*******************
        Preloader end
    ********************-->

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper" >
	

        <!--**********************************
            Nav header start
        ***********************************-->
		<div class="nav-header">
            <a href="/" class="brand-logo">
				<div class="logo">
					<svg class="logo-abbr" width="43" height="34" viewbox="0 0 43 34" fill="none" xmlns="http://www.w3.org/2000/svg">
						<rect x="22.6154" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
						<rect x="22.6154" y="9.15387" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
						<rect x="22.6154" y="18.3077" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
						<rect x="0.384583" y="18.3077" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
						<rect x="22.6154" y="27.4615" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
						<rect x="0.384583" y="27.4615" width="19.6154" height="6.53846" rx="3.26923" fill="white"></rect>
					</svg>
					<svg class="brand-title" width="124" height="33" viewbox="0 0 132 33" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M11.65 2.516C14.758 2.516 17.474 3.132 19.798 4.364C22.122 5.596 23.914 7.332 25.174 9.572C26.462 11.784 27.106 14.346 27.106 17.258C27.106 20.142 26.462 22.704 25.174 24.944C23.914 27.184 22.108 28.92 19.756 30.152C17.432 31.384 14.73 32 11.65 32H0.604V2.516H11.65ZM11.188 25.784C13.904 25.784 16.018 25.042 17.53 23.558C19.042 22.074 19.798 19.974 19.798 17.258C19.798 14.542 19.042 12.428 17.53 10.916C16.018 9.404 13.904 8.648 11.188 8.648H7.786V25.784H11.188ZM41.7876 32.336C39.4916 32.336 37.4196 31.846 35.5716 30.866C33.7516 29.886 32.3096 28.486 31.2456 26.666C30.2096 24.846 29.6916 22.718 29.6916 20.282C29.6916 17.874 30.2236 15.76 31.2876 13.94C32.3516 12.092 33.8076 10.678 35.6556 9.698C37.5036 8.718 39.5756 8.228 41.8716 8.228C44.1676 8.228 46.2396 8.718 48.0876 9.698C49.9356 10.678 51.3916 12.092 52.4556 13.94C53.5196 15.76 54.0516 17.874 54.0516 20.282C54.0516 22.69 53.5056 24.818 52.4136 26.666C51.3496 28.486 49.8796 29.886 48.0036 30.866C46.1556 31.846 44.0836 32.336 41.7876 32.336ZM41.7876 26.12C43.1596 26.12 44.3216 25.616 45.2736 24.608C46.2536 23.6 46.7436 22.158 46.7436 20.282C46.7436 18.406 46.2676 16.964 45.3156 15.956C44.3916 14.948 43.2436 14.444 41.8716 14.444C40.4716 14.444 39.3096 14.948 38.3856 15.956C37.4616 16.936 36.9996 18.378 36.9996 20.282C36.9996 22.158 37.4476 23.6 38.3436 24.608C39.2676 25.616 40.4156 26.12 41.7876 26.12ZM65.0438 26.456H74.4518V32H57.8618V2.516H65.0438V26.456ZM76.4494 20.24C76.4494 17.832 76.8974 15.718 77.7934 13.898C78.7174 12.078 79.9634 10.678 81.5314 9.698C83.0994 8.718 84.8494 8.228 86.7814 8.228C88.4334 8.228 89.8754 8.564 91.1074 9.236C92.3674 9.908 93.3334 10.79 94.0054 11.882V8.564H101.187V32H94.0054V28.682C93.3054 29.774 92.3254 30.656 91.0654 31.328C89.8334 32 88.3914 32.336 86.7394 32.336C84.8354 32.336 83.0994 31.846 81.5314 30.866C79.9634 29.858 78.7174 28.444 77.7934 26.624C76.8974 24.776 76.4494 22.648 76.4494 20.24ZM94.0054 20.282C94.0054 18.49 93.5014 17.076 92.4934 16.04C91.5134 15.004 90.3094 14.486 88.8814 14.486C87.4534 14.486 86.2354 15.004 85.2274 16.04C84.2474 17.048 83.7574 18.448 83.7574 20.24C83.7574 22.032 84.2474 23.46 85.2274 24.524C86.2354 25.56 87.4534 26.078 88.8814 26.078C90.3094 26.078 91.5134 25.56 92.4934 24.524C93.5014 23.488 94.0054 22.074 94.0054 20.282ZM113.565 11.882C114.237 10.79 115.203 9.908 116.463 9.236C117.723 8.564 119.165 8.228 120.789 8.228C122.721 8.228 124.471 8.718 126.039 9.698C127.607 10.678 128.839 12.078 129.735 13.898C130.659 15.718 131.121 17.832 131.121 20.24C131.121 22.648 130.659 24.776 129.735 26.624C128.839 28.444 127.607 29.858 126.039 30.866C124.471 31.846 122.721 32.336 120.789 32.336C119.137 32.336 117.695 32.014 116.463 31.37C115.231 30.698 114.265 29.816 113.565 28.724V32H106.383V0.92H113.565V11.882ZM123.813 20.24C123.813 18.448 123.309 17.048 122.301 16.04C121.321 15.004 120.103 14.486 118.647 14.486C117.219 14.486 116.001 15.004 114.993 16.04C114.013 17.076 113.523 18.49 113.523 20.282C113.523 22.074 114.013 23.488 114.993 24.524C116.001 25.56 117.219 26.078 118.647 26.078C120.075 26.078 121.293 25.56 122.301 24.524C123.309 23.46 123.813 22.032 123.813 20.24Z" fill="white"></path>
					</svg>

				</div>

            </a>
            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span>
					<span class="line"></span>
					<span class="line"></span>
					<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path opacity="0.4" d="M16.7548 0.333313H20.7051C22.341 0.333313 23.6667 1.67014 23.6667 3.31994V7.30359C23.6667 8.95339 22.341 10.2902 20.7051 10.2902H16.7548C15.1188 10.2902 13.7932 8.95339 13.7932 7.30359V3.31994C13.7932 1.67014 15.1188 0.333313 16.7548 0.333313Z" fill="white"></path>
						<path fill-rule="evenodd" clip-rule="evenodd" d="M3.29492 0.333313H7.24522C8.8812 0.333313 10.2068 1.67014 10.2068 3.31994V7.30359C10.2068 8.95339 8.8812 10.2902 7.24522 10.2902H3.29492C1.65894 10.2902 0.333313 8.95339 0.333313 7.30359V3.31994C0.333313 1.67014 1.65894 0.333313 3.29492 0.333313ZM3.29492 13.7097H7.24522C8.8812 13.7097 10.2068 15.0466 10.2068 16.6964V20.68C10.2068 22.3287 8.8812 23.6666 7.24522 23.6666H3.29492C1.65894 23.6666 0.333313 22.3287 0.333313 20.68V16.6964C0.333313 15.0466 1.65894 13.7097 3.29492 13.7097ZM20.705 13.7097H16.7547C15.1188 13.7097 13.7931 15.0466 13.7931 16.6964V20.68C13.7931 22.3287 15.1188 23.6666 16.7547 23.6666H20.705C22.341 23.6666 23.6666 22.3287 23.6666 20.68V16.6964C23.6666 15.0466 22.341 13.7097 20.705 13.7097Z" fill="white"></path>
					</svg>
						
                </div>
            </div>
		
        </div>
        <!--**********************************
            Nav header end
        ***********************************-->
		
		<!--**********************************
            Chat box start
        ***********************************-->
	
		<!--**********************************
            Chat box End
        ***********************************-->
		
		<!--**********************************
            Header start
        ***********************************-->
        <div class="header">
            <div class="header-content">
                <nav class="navbar navbar-expand">
                    <div class="collapse navbar-collapse justify-content-between">
                        <div class="header-left">
							<div class="dashboard_bar">
                                Dashboard
                            </div>
                        </div>
                       
						<div class="dropdown header-profile2 ">
							<ul class="navbar-nav header-right me-sm-4">
								<li class="nav-item dropdown notification_dropdown">
									<a class="nav-link" href="javascript:void(0);" role="button" data-bs-toggle="dropdown">
										<svg width="20" height="21" viewbox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M15.8333 11H17.5833C18.5498 11 19.3333 11.7835 19.3333 12.75C19.3333 13.7165 18.5498 14.5 17.5833 14.5H2.41666C1.45016 14.5 0.666656 13.7165 0.666656 12.75C0.666656 11.7835 1.45016 11 2.41666 11H4.16666L4.81798 5.13812C5.11136 2.49763 7.34325 0.5 9.99999 0.5C12.6567 0.5 14.8886 2.49763 15.182 5.13812L15.8333 11Z" fill="#B9A8FF"></path>
											<path opacity="0.3" d="M12.3333 18C12.3333 16.7114 11.2887 15.6667 9.99999 15.6667C8.71133 15.6667 7.66666 16.7114 7.66666 18C7.66666 19.2887 8.71133 20.3334 9.99999 20.3334C11.2887 20.3334 12.3333 19.2887 12.3333 18Z" fill="#B9A8FF"></path>
										</svg>
									</a>
									
								</li>
								<li class="nav-item dropdown notification_dropdown">
									<a class="nav-link bell-link " href="javascript:void(0);">
										<svg width="28" height="28" viewbox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path opacity="0.3" fill-rule="evenodd" clip-rule="evenodd" d="M7.00001 2.33331H21C21.6443 2.33331 22.1667 2.85565 22.1667 3.49998V15.1666C22.1667 15.811 21.6443 16.3333 21 16.3333H7.00001C6.35568 16.3333 5.83334 15.811 5.83334 15.1666V3.49998C5.83334 2.85565 6.35568 2.33331 7.00001 2.33331ZM16.1 4.66665C15.3489 4.66665 14.4705 5.51814 14 6.06665C13.5295 5.51814 12.6511 4.66665 11.9 4.66665C10.5705 4.66665 9.80001 5.70366 9.80001 7.0235C9.80001 8.4856 11.2 10.0333 14 11.6666C16.8 10.0333 18.2 8.51665 18.2 7.11665C18.2 5.79681 17.4295 4.66665 16.1 4.66665Z" fill="#B9A8FF"></path>
											<path fill-rule="evenodd" clip-rule="evenodd" d="M4.42487 7.66798L14 14.5833L23.5751 7.66798C23.8363 7.47935 24.2009 7.53816 24.3896 7.79933C24.4614 7.89874 24.5 8.01825 24.5 8.14087V19.8333C24.5 21.122 23.4553 22.1667 22.1667 22.1667H5.83333C4.54467 22.1667 3.5 21.122 3.5 19.8333V8.14087C3.5 7.81871 3.76117 7.55754 4.08333 7.55754C4.20596 7.55754 4.32546 7.59618 4.42487 7.66798Z" fill="#B9A8FF"></path>
										</svg>
									</a>
								</li>	
								<li class="nav-item dropdown notification_dropdown">
									<a class="nav-link " href="javascript:void(0);" data-bs-toggle="dropdown">
										<svg width="28" height="29" viewbox="0 0 28 29" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M3.5 19.7699V10.8881H24.5V19.8411C24.5 23.5032 22.1948 25.7549 18.5066 25.7549H9.48189C5.82821 25.7549 3.5 23.4566 3.5 19.7699ZM9.28595 16.8999C8.75576 16.9244 8.31778 16.5032 8.29473 15.9677C8.29473 15.4311 8.70966 14.9877 9.23985 14.9632C9.75851 14.9632 10.185 15.3727 10.1965 15.8966C10.2195 16.4344 9.80461 16.8777 9.28595 16.8999ZM14.0231 16.8999C13.4929 16.9244 13.0549 16.5032 13.0318 15.9677C13.0318 15.4311 13.4468 14.9877 13.9769 14.9632C14.4956 14.9632 14.9221 15.3727 14.9336 15.8966C14.9566 16.4344 14.5417 16.8777 14.0231 16.8999ZM18.7256 21.1932C18.1954 21.1816 17.7689 20.7382 17.7689 20.2016C17.7574 19.6649 18.1839 19.2227 18.714 19.2111H18.7256C19.2673 19.2111 19.7053 19.6544 19.7053 20.2016C19.7053 20.7499 19.2673 21.1932 18.7256 21.1932ZM13.0318 20.2016C13.0549 20.7382 13.4929 21.1594 14.0231 21.1349C14.5417 21.1127 14.9566 20.6694 14.9336 20.1327C14.9221 19.6077 14.4956 19.1982 13.9769 19.1982C13.4468 19.2227 13.0318 19.6649 13.0318 20.2016ZM8.28321 20.2016C8.30626 20.7382 8.74424 21.1594 9.27442 21.1349C9.79308 21.1127 10.208 20.6694 10.185 20.1327C10.1734 19.6077 9.74698 19.1982 9.22832 19.1982C8.69813 19.2227 8.28321 19.6649 8.28321 20.2016ZM17.7805 15.9561C17.7805 15.4194 18.1954 14.9877 18.7256 14.9761C19.2442 14.9761 19.6592 15.3949 19.6822 15.9094C19.6937 16.4461 19.2788 16.8894 18.7602 16.8999C18.23 16.9116 17.792 16.5032 17.7805 15.9677V15.9561Z" fill="#B9A8FF"></path>
											<path opacity="0.4" d="M3.50391 10.888C3.51889 10.2031 3.57652 8.84396 3.68486 8.40646C4.2381 5.94596 6.1168 4.38262 8.80232 4.15979H19.1986C21.861 4.39429 23.7628 5.96812 24.316 8.40646C24.4232 8.83229 24.4809 10.202 24.4958 10.888H3.50391Z" fill="#B9A8FF"></path>
											<path d="M9.689 7.77657C10.1961 7.77657 10.5765 7.39274 10.5765 6.87824V3.32107C10.5765 2.80657 10.1961 2.42157 9.689 2.42157C9.18187 2.42157 8.80151 2.80657 8.80151 3.32107V6.87824C8.80151 7.39274 9.18187 7.77657 9.689 7.77657Z" fill="#B9A8FF"></path>
											<path d="M18.3108 7.77657C18.8064 7.77657 19.1983 7.39274 19.1983 6.87824V3.32107C19.1983 2.80657 18.8064 2.42157 18.3108 2.42157C17.8036 2.42157 17.4233 2.80657 17.4233 3.32107V6.87824C17.4233 7.39274 17.8036 7.77657 18.3108 7.77657Z" fill="#B9A8FF"></path>
										</svg>
									</a>
									
								</li>
							</ul>
							<a class="nav-link user-profile" href="javascript:void(0);" role="button" data-bs-toggle="dropdown">
								<div class="header-info2 d-flex align-items-center">
									<img src="images/placeholder-1.jpg" alt="">
									
								</div>
							</a>
							
						
						</div>
                    </div>
				</nav>
			</div>
		</div>
        <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

        <!--**********************************
            Sidebar start
        ***********************************-->
		<div class="dlabnav">
			<div class="dlabnav-scroll">
				
				<ul class="metismenu" id="menu">
					<li><a class="has-arrow " href="home" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g id="IconlyHome"><g id="Home">
								<path id="Home_2" d="M9.13478 20.7733V17.7156C9.13478 16.9351 9.77217 16.3023 10.5584 16.3023H13.4326C13.8102 16.3023 14.1723 16.4512 14.4393 16.7163C14.7063 16.9813 14.8563 17.3408 14.8563 17.7156V20.7733C14.8539 21.0978 14.9821 21.4099 15.2124 21.6402C15.4427 21.8705 15.7561 22 16.0829 22H18.0438C18.9596 22.0023 19.8388 21.6428 20.4872 21.0008C21.1356 20.3588 21.5 19.487 21.5 18.5778V9.86686C21.5 9.13246 21.1721 8.43584 20.6046 7.96467L13.934 2.67587C12.7737 1.74856 11.1111 1.7785 9.98539 2.74698L3.46701 7.96467C2.87274 8.42195 2.51755 9.12064 2.5 9.86686V18.5689C2.5 20.4639 4.04738 22 5.95617 22H7.87229C8.55123 22 9.103 21.4562 9.10792 20.7822L9.13478 20.7733Z" fill="#130F26"></path>
								</g></g>
							</svg>
						</div>	
							<span class="nav-text">Dashboard</span>
						</a>
						
					</li>
					
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M9.34933 14.8577C5.38553 14.8577 2 15.47 2 17.9174C2 20.3666 5.364 21 9.34933 21C13.3131 21 16.6987 20.3877 16.6987 17.9404C16.6987 15.4911 13.3347 14.8577 9.34933 14.8577Z" fill="#B9A8FF"></path>
								<path opacity="0.4" d="M9.34935 12.5248C12.049 12.5248 14.2124 10.4062 14.2124 7.76241C14.2124 5.11865 12.049 3 9.34935 3C6.65072 3 4.48633 5.11865 4.48633 7.76241C4.48633 10.4062 6.65072 12.5248 9.34935 12.5248Z" fill="#763ed0"></path>
								<path opacity="0.4" d="M16.1734 7.84875C16.1734 9.19507 15.7605 10.4513 15.0364 11.4948C14.9611 11.6021 15.0276 11.7468 15.1587 11.7698C15.3407 11.7995 15.5276 11.8177 15.7184 11.8216C17.6167 11.8704 19.3202 10.6736 19.7908 8.87118C20.4885 6.19676 18.4415 3.79543 15.8339 3.79543C15.5511 3.79543 15.2801 3.82418 15.0159 3.87688C14.9797 3.88454 14.9405 3.90179 14.921 3.93246C14.8955 3.97174 14.9141 4.02253 14.9395 4.05607C15.7233 5.13216 16.1734 6.44207 16.1734 7.84875Z" fill="#763ed0"></path>
								<path d="M21.7791 15.1693C21.4317 14.444 20.5932 13.9466 19.3172 13.7023C18.7155 13.5586 17.0853 13.3545 15.5697 13.3832C15.5472 13.3861 15.5344 13.4014 15.5325 13.411C15.5295 13.4263 15.5364 13.4493 15.5658 13.4656C16.2663 13.8048 18.9738 15.2805 18.6333 18.3928C18.6186 18.5289 18.7292 18.6439 18.8671 18.6247C19.5335 18.5318 21.2478 18.1705 21.7791 17.0475C22.0736 16.4534 22.0736 15.7635 21.7791 15.1693Z" fill="#B9A8FF"></path>
								</svg>
						</div>	
							
							<span class="nav-text">Funds</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="pay">Deposit</a></li>
							<li><a href="withdraw">Withdraw</a></li>
								<li><a href="withdrawallogs">Withdrawal Records</a></li>
								
							
						
						</ul>
					</li>
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g id="IconlyActivity">
								<g id="Activity">
								<path id="Activity_2" fill-rule="evenodd" clip-rule="evenodd" d="M17.1799 4.41C17.1799 3.08 18.2599 2 19.5899 2C20.9199 2 21.9999 3.08 21.9999 4.41C21.9999 5.74 20.9199 6.82 19.5899 6.82C18.2599 6.82 17.1799 5.74 17.1799 4.41ZM13.3298 14.7593L16.2198 11.0303L16.1798 11.0503C16.3398 10.8303 16.3698 10.5503 16.2598 10.3003C16.1508 10.0503 15.9098 9.8803 15.6508 9.8603C15.3798 9.8303 15.1108 9.9503 14.9498 10.1703L12.5308 13.3003L9.75976 11.1203C9.58976 10.9903 9.38976 10.9393 9.18976 10.9603C8.99076 10.9903 8.81076 11.0993 8.68976 11.2593L5.73076 15.1103L5.66976 15.2003C5.49976 15.5193 5.57976 15.9293 5.87976 16.1503C6.01976 16.2403 6.16976 16.3003 6.33976 16.3003C6.57076 16.3103 6.78976 16.1893 6.92976 16.0003L9.43976 12.7693L12.2898 14.9103L12.3798 14.9693C12.6998 15.1393 13.0998 15.0603 13.3298 14.7593ZM15.4498 3.7803C15.4098 4.0303 15.3898 4.2803 15.3898 4.5303C15.3898 6.7803 17.2098 8.5993 19.4498 8.5993C19.6998 8.5993 19.9398 8.5703 20.1898 8.5303V16.5993C20.1898 19.9903 18.1898 22.0003 14.7898 22.0003H7.40076C3.99976 22.0003 1.99976 19.9903 1.99976 16.5993V9.2003C1.99976 5.8003 3.99976 3.7803 7.40076 3.7803H15.4498Z" fill="#130F26"></path>
								</g></g>
								</svg>	
						</div>		
							<span class="nav-text">Online Writing</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="onlinewriting">Start Writing</a></li>
							<li><a href="onlinewritinglogs">Task Records</a></li>
						
						
						</ul>
					</li>
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path opacity="0.4" d="M11.7759 21.8374C9.49286 20.4273 7.37056 18.7645 5.44782 16.8796C4.09044 15.5338 3.0538 13.8905 2.4171 12.0753C1.27947 8.53523 2.60374 4.48948 6.30105 3.2884C8.25256 2.67553 10.375 3.05175 12.007 4.29983C13.6396 3.05315 15.7613 2.67705 17.7129 3.2884C21.4102 4.48948 22.7434 8.53523 21.6058 12.0753C20.9742 13.8888 19.9438 15.5319 18.5928 16.8796C16.6683 18.7625 14.5463 20.4251 12.2647 21.8374L12.0159 22L11.7759 21.8374Z" fill="#B9A8FF"></path>
								<path d="M12.0109 22L11.776 21.8374C9.49013 20.4274 7.36487 18.7647 5.43902 16.8796C4.0752 15.5356 3.03238 13.8922 2.39052 12.0753C1.26177 8.53523 2.58605 4.48948 6.28335 3.2884C8.23486 2.67553 10.3853 3.05204 12.0109 4.31057V22Z" fill="#B9A8FF"></path>
								<path d="M18.2304 9.99922C18.0296 9.98629 17.8425 9.8859 17.7131 9.72157C17.5836 9.55723 17.5232 9.3434 17.5459 9.13016C17.5677 8.4278 17.168 7.78851 16.5517 7.53977C16.1609 7.43309 15.9243 7.00987 16.022 6.59249C16.1148 6.18182 16.4993 5.92647 16.8858 6.0189C16.9346 6.027 16.9816 6.04468 17.0244 6.07105C18.2601 6.54658 19.0601 7.82641 18.9965 9.22576C18.9944 9.43785 18.9117 9.63998 18.7673 9.78581C18.6229 9.93164 18.4291 10.0087 18.2304 9.99922Z" fill="#763ed0"></path>
							</svg>
						</div>	
							<span class="nav-text">Trivia</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="takesurvey">Start Trivia</a></li>
							<li><a href="completedsurvey">Trivia Records</a></li>
						

						</ul>
					</li>
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g id="IconlyFilter">
								<g id="Filter">
								<path id="Filter_2" fill-rule="evenodd" clip-rule="evenodd" d="M8.87774 6.37856C8.87774 8.24523 7.33886 9.75821 5.43887 9.75821C3.53999 9.75821 2 8.24523 2 6.37856C2 4.51298 3.53999 3 5.43887 3C7.33886 3 8.87774 4.51298 8.87774 6.37856ZM20.4933 4.89833C21.3244 4.89833 22 5.56203 22 6.37856C22 7.19618 21.3244 7.85989 20.4933 7.85989H13.9178C13.0856 7.85989 12.4101 7.19618 12.4101 6.37856C12.4101 5.56203 13.0856 4.89833 13.9178 4.89833H20.4933ZM3.50777 15.958H10.0833C10.9155 15.958 11.5911 16.6217 11.5911 17.4393C11.5911 18.2558 10.9155 18.9206 10.0833 18.9206H3.50777C2.67555 18.9206 2 18.2558 2 17.4393C2 16.6217 2.67555 15.958 3.50777 15.958ZM18.5611 20.7778C20.4611 20.7778 22 19.2648 22 17.3992C22 15.5325 20.4611 14.0196 18.5611 14.0196C16.6623 14.0196 15.1223 15.5325 15.1223 17.3992C15.1223 19.2648 16.6623 20.7778 18.5611 20.7778Z" fill="#130F26"></path>
								</g></g></svg>
						</div>		
							<span class="nav-text">Spins</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="spinnow">Spin Now</a></li>
							<li><a href="spinrecord">Spin Records</a></li>
							
							
						</ul>
					</li>
					
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g id="IconlyDocument">
								<g id="Document">
								<path id="Document_2" fill-rule="evenodd" clip-rule="evenodd" d="M7.81 2H16.191C19.28 2 21 3.78 21 6.83V17.16C21 20.26 19.28 22 16.191 22H7.81C4.77 22 3 20.26 3 17.16V6.83C3 3.78 4.77 2 7.81 2ZM8.08 6.66V6.65H11.069C11.5 6.65 11.85 7 11.85 7.429C11.85 7.87 11.5 8.22 11.069 8.22H8.08C7.649 8.22 7.3 7.87 7.3 7.44C7.3 7.01 7.649 6.66 8.08 6.66ZM8.08 12.74H15.92C16.35 12.74 16.7 12.39 16.7 11.96C16.7 11.53 16.35 11.179 15.92 11.179H8.08C7.649 11.179 7.3 11.53 7.3 11.96C7.3 12.39 7.649 12.74 8.08 12.74ZM8.08 17.31H15.92C16.319 17.27 16.62 16.929 16.62 16.53C16.62 16.12 16.319 15.78 15.92 15.74H8.08C7.78 15.71 7.49 15.85 7.33 16.11C7.17 16.36 7.17 16.69 7.33 16.95C7.49 17.2 7.78 17.35 8.08 17.31Z" fill="#130F26"></path>
								</g>
								</g>
							</svg>
						</div>	
							<span class="nav-text">Videos</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="videos">Watch Now</a></li>
							<li><a href="youtuberecords">Youtube Records</a></li>
							
						</ul>
					</li>
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g id="IconlyDocument">
								<g id="Document">
								<path id="Document_2" fill-rule="evenodd" clip-rule="evenodd" d="M7.81 2H16.191C19.28 2 21 3.78 21 6.83V17.16C21 20.26 19.28 22 16.191 22H7.81C4.77 22 3 20.26 3 17.16V6.83C3 3.78 4.77 2 7.81 2ZM8.08 6.66V6.65H11.069C11.5 6.65 11.85 7 11.85 7.429C11.85 7.87 11.5 8.22 11.069 8.22H8.08C7.649 8.22 7.3 7.87 7.3 7.44C7.3 7.01 7.649 6.66 8.08 6.66ZM8.08 12.74H15.92C16.35 12.74 16.7 12.39 16.7 11.96C16.7 11.53 16.35 11.179 15.92 11.179H8.08C7.649 11.179 7.3 11.53 7.3 11.96C7.3 12.39 7.649 12.74 8.08 12.74ZM8.08 17.31H15.92C16.319 17.27 16.62 16.929 16.62 16.53C16.62 16.12 16.319 15.78 15.92 15.74H8.08C7.78 15.71 7.49 15.85 7.33 16.11C7.17 16.36 7.17 16.69 7.33 16.95C7.49 17.2 7.78 17.35 8.08 17.31Z" fill="#130F26"></path>
								</g>
								</g>
							</svg>
						</div>	
							<span class="nav-text">Services</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="carhire">Car Hire</a></li>
							<li><a href="carhirehistory">Car hire Records</a></li>
							
						</ul>
					</li>
					<li><a class="has-arrow " href="javascript:void()" aria-expanded="false">
						<div class="menu-icon">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<g id="IconlySwap">
							<g id="Swap">
							<path id="Swap_2" fill-rule="evenodd" clip-rule="evenodd" d="M7.54618 3.27793C7.71236 3.39789 7.98037 3.67345 7.98037 3.67345C9.02079 4.64858 10.5879 7.07394 11.0911 8.30444C11.1016 8.30444 11.4001 9.03608 11.4118 9.38409V9.43041C11.4118 9.96371 11.1133 10.4626 10.6335 10.7179C10.4357 10.8232 9.95456 10.9211 9.72244 10.9683C9.64556 10.984 9.59599 10.9941 9.59308 10.997C8.90727 11.1016 7.85514 11.1704 6.70003 11.1704C5.48757 11.1704 4.38981 11.1016 3.71453 10.9733C3.70282 10.9733 3.08606 10.8462 2.88009 10.7642C2.58282 10.6372 2.3312 10.4044 2.17087 10.1145C2.05618 9.88294 2 9.63827 2 9.38409C2.01053 9.11685 2.18257 8.618 2.26215 8.42083C2.76539 7.12026 4.41204 4.6367 5.41852 3.68532C5.52307 3.57922 5.64206 3.46806 5.72485 3.39071C5.76902 3.34945 5.8029 3.3178 5.81877 3.30169C6.07039 3.10452 6.37936 3 6.71173 3C7.00783 3 7.30509 3.09264 7.54618 3.27793ZM18.2286 10.1618C18.2286 10.6856 17.8108 11.1096 17.2947 11.1096C16.7786 11.1096 16.3608 10.6856 16.3608 10.1618L16.1033 5.58295C16.1033 4.91543 16.637 4.375 17.2947 4.375C17.9524 4.375 18.4849 4.91543 18.4849 5.58295L18.2286 10.1618ZM21.1199 13.2356C21.4172 13.3639 21.6688 13.5955 21.8291 13.8853C21.9438 14.1169 22 14.3616 22 14.617C21.9895 14.883 21.8174 15.3831 21.7367 15.5802C21.2346 16.8797 19.5868 19.3633 18.5815 20.3158C18.4787 20.4194 18.3619 20.5284 18.2793 20.6055L18.2792 20.6055C18.2331 20.6486 18.1976 20.6817 18.1812 20.6983C17.9284 20.8955 17.6206 21 17.2894 21C16.991 21 16.6937 20.9074 16.4538 20.7209C16.2876 20.6021 16.0196 20.3265 16.0196 20.3265C14.978 19.3526 13.4121 16.926 12.9089 15.6954C12.8972 15.6954 12.5999 14.965 12.5882 14.617V14.5706C12.5882 14.0361 12.8855 13.5373 13.3665 13.2819C13.5639 13.1777 14.0435 13.0796 14.2762 13.0319L14.2762 13.0319C14.3539 13.016 14.404 13.0058 14.4069 13.0028C15.0927 12.8983 16.1449 12.8294 17.3 12.8294C18.5124 12.8294 19.6102 12.8983 20.2855 13.0265C20.296 13.0265 20.9139 13.1536 21.1199 13.2356ZM6.70553 12.8905C6.18942 12.8905 5.77161 13.3146 5.77161 13.8383L5.51414 18.4171C5.51414 19.0846 6.04781 19.625 6.70553 19.625C7.36325 19.625 7.89575 19.0846 7.89575 18.4171L7.63945 13.8383C7.63945 13.3146 7.22165 12.8905 6.70553 12.8905Z" fill="#130F26"></path>
							</g>
							</g>
							</svg>
						</div>	
							<span class="nav-text">Affiliate</span>
						</a>
						<ul aria-expanded="false">
							<li><a href="ref">Level 1</a></li>
							<li><a href="level2">Level 2</a></li>
						</ul>
					</li>
					<li>
					    

                               
						<a class="has-arrow " href="<?php echo e(route('logout')); ?>"   onclick="event.preventDefault();
                                                 document.getElementById('logout-form').submit();">
							<div class="menu-icon">
								<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path opacity="0.4" d="M2.00024 11.0785C2.05024 13.4165 2.19024 17.4155 2.21024 17.8565C2.28124 18.7995 2.64224 19.7525 3.20424 20.4245C3.98624 21.3675 4.94924 21.7885 6.29224 21.7885C8.14824 21.7985 10.1942 21.7985 12.1812 21.7985C14.1762 21.7985 16.1122 21.7985 17.7472 21.7885C19.0712 21.7885 20.0642 21.3565 20.8362 20.4245C21.3982 19.7525 21.7592 18.7895 21.8102 17.8565C21.8302 17.4855 21.9302 13.1445 21.9902 11.0785H2.00024Z" fill="#763ed0"></path>
								<path d="M11.2455 15.3842V16.6782C11.2455 17.0922 11.5815 17.4282 11.9955 17.4282C12.4095 17.4282 12.7455 17.0922 12.7455 16.6782V15.3842C12.7455 14.9702 12.4095 14.6342 11.9955 14.6342C11.5815 14.6342 11.2455 14.9702 11.2455 15.3842Z" fill="#763ed0"></path>
								<path fill-rule="evenodd" clip-rule="evenodd" d="M10.2114 14.5564C10.1114 14.9194 9.76237 15.1514 9.38437 15.1014C6.83337 14.7454 4.39537 13.8404 2.33737 12.4814C2.12637 12.3434 2.00037 12.1074 2.00037 11.8554V8.3894C2.00037 6.2894 3.71237 4.5814 5.81737 4.5814H7.78437C7.97237 3.1294 9.20237 2.0004 10.7044 2.0004H13.2864C14.7874 2.0004 16.0184 3.1294 16.2064 4.5814H18.1834C20.2824 4.5814 21.9904 6.2894 21.9904 8.3894V11.8554C21.9904 12.1074 21.8634 12.3424 21.6544 12.4814C19.5924 13.8464 17.1444 14.7554 14.5764 15.1104C14.5414 15.1154 14.5074 15.1174 14.4734 15.1174C14.1344 15.1174 13.8314 14.8884 13.7464 14.5524C13.5444 13.7564 12.8214 13.1994 11.9904 13.1994C11.1484 13.1994 10.4334 13.7444 10.2114 14.5564ZM13.2864 3.5004H10.7044C10.0314 3.5004 9.46937 3.9604 9.30137 4.5814H14.6884C14.5204 3.9604 13.9584 3.5004 13.2864 3.5004Z" fill="#B9A8FF"></path>
								</svg>
							</div>	
							<span class="nav-text">Logout</span>
							 <form id="logout-form" action="logout" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
						</a>
						
					</li>
				</ul>
				
				<div class="copyright">
					<p class="fs-14">Topgain © 2023 All Rights Reserved</p>
					
				</div>
			</div>
		</div>
		
		
        <!--**********************************
            Sidebar end
        ***********************************-->
		
		<!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
			<div class="container-fluid">
				<div class="row">
					<div class="col-xl-9">
						<div class="row">
							<!----column-- -->
							<div class="col-xl-8">
								<div class="card balance-data">
									<div class="card-header border-0 flex-wrap">
										<h4 class="fs-18 font-w600">Summary</h4>
									
									</div>
								
								</div>
							</div>
							<!----/column-- -->
							<!----column-- -->
							<div class="col-xl-4">
								<div class="row">
								
								<!----/column-- -->
								<!----column-- -->
							
								<!----/column-- -->
								<!----column-- -->
							
								<!---/-column-- -->
							</div>
						</div>
							<!----column-- -->
							
							<!----/column-- -->	
							<!----column-- -->
					<div class="tab-pane fade active show" id="all-transactions" role="tabpanel">
								<div class="table-responsive ">
									<table style="width:15px" class=" table display mb-4 dataTablesCard order-table card-table text-black dataTable no-footer student-tbl" id="example5">
										<thead >
											<tr style="width:15px">
											
											
											
											
												<th style="width:15px">Amount</th>
												<th style="width:15px">Type</th>
													<th style="width:15px">Days</th>
											
												<th style="width:15px">Status</th>
													<th style="width:15px">Date</th>
											
											</tr>
										</thead>
										<tbody style="width:15px">
										     <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
											
											
												
												
												<td class="whitesp-no amount"><a href="">KSH <?php echo e($data->amount); ?> </a></td>
												<td class="income">
													<span class="me-2">
														<svg width="39" height="39" viewbox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect x="39" y="39" width="39" height="39" rx="19.5" transform="rotate(-180 39 39)" fill="#2BC155" fill-opacity="0.11"></rect>
															<path opacity="1" d="M11.667 19.8333C11.667 19.4167 12.0837 19 12.5003 19C12.917 19 13.3337 19.4167 13.3337 19.8333C13.3337 20.1111 13.3337 21.5 13.3337 24C13.3337 24.9205 14.0799 25.6667 15.0003 25.6667H25.0003C25.9208 25.6667 26.667 24.9205 26.667 24V19.8333C26.667 19.3731 27.0401 19 27.5003 19C27.9606 19 28.3337 19.3731 28.3337 19.8333V24C28.3337 25.8409 26.8413 27.3333 25.0003 27.3333H15.0003C13.1594 27.3333 11.667 25.8409 11.667 24C11.667 21.5 11.667 20.1111 11.667 19.8333Z" fill="#13C28F"></path>
															<path opacity="1" d="M19.1663 20.6667C19.1663 21.1269 19.5394 21.5 19.9997 21.5C20.4599 21.5 20.833 21.1269 20.833 20.6667V10.6667C20.833 10.2064 20.4599 9.83333 19.9997 9.83333C19.5394 9.83333 19.1663 10.2064 19.1663 10.6667V20.6667Z" fill="#13C28F"></path>
															<path d="M23.5774 16.7441C23.9028 16.4186 24.4305 16.4186 24.7559 16.7441C25.0814 17.0695 25.0814 17.5972 24.7559 17.9226L20.5893 22.0893C20.2759 22.4027 19.772 22.4159 19.4425 22.1194L15.2759 18.3694C14.9338 18.0615 14.906 17.5346 15.2139 17.1925C15.5218 16.8504 16.0487 16.8227 16.3908 17.1306L19.9698 20.3517L23.5774 16.7441Z" fill="#13C28F"></path>
														</svg>
													</span>
												 <?php echo e($data->cartype); ?>

												</td>
													<td class="whitesp-no"><?php echo e($data->days); ?></td>
											
											
												    
												      <?php if($data->status == 0): ?>
                                                <td class="income">	<span class="btn btn-outline-danger btn-xs">Pending</span></td>
                                            <?php else: ?>
                                                <td class="income">	<span class="btn btn-outline-danger btn-xs">Approved</span></td>
                                                <?php endif; ?>
                                                	<td class="whitesp-no"><?php echo e($data->created_at); ?></td>
												    
										
											</tr>   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
																			
										</tbody>
									</table>
								</div>
							</div>
							<!-- --/tab-pane -->
							<!-- --tab-pane -->
							<div class="tab-pane fade " id="completed" role="tabpanel">
								<div class="table-responsive ">
									<table class="table-responsive-lg table display mb-4 dataTablesCard order-table card-table text-black dataTable no-footer student-tbl" id="example5">
										<thead>
											<tr>
												<th>
													<div class="checkbox mr-0 align-self-center">
														<div class="custom-control custom-checkbox ">
															<input type="checkbox" class="form-check-input" id="checkAll" required="">
															<label class="custom-control-label" for="checkAll"></label>
														</div>
													</div>
												</th>
												<th>ID Invoice</th>
												<th>Date</th>
												<th>Recipient</th>
												<th>Amount</th>
												<th>Type</th>
												<th>Location</th>
												<th>Status</th>
												<th></th>
											</tr>
										</thead>
										<tbody>
											
											<tr>
												<td>
													<div class="checkbox mr-0 align-self-center">
														<div class="custom-control custom-checkbox ">
															<input type="checkbox" class="form-check-input" id="check89" required="">
															<label class="custom-control-label" for="check89"></label>
														</div>
													</div>
												</td>
												<td>#123412451</td>
												<td class="whitesp-no">June 1, 2020, 08:22 AM</td>
												<td class="whitesp-no p-0">
													<div class="d-flex py-sm-3 py-1 align-items-center">
														<span class=" me-3">
															<img src="images/avatar/LB.png" alt="" width="50" class="rounded-3 img-history">
														</span>
														<div>
															<h6 class="font-w500 fs-16 mb-0">Marcus</h6>
															<span class="fs-14 font-w400"> <a href="app-profile.html">Freelancer </a></span>
														</div>												
													</div>
												</td>
												<td class="whitesp-no amount"><a href="ecom-invoice.html">$128.89 </a></td>
												<td class="income">
													<span class="me-2">
														<svg width="39" height="39" viewbox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect width="39" height="39" rx="19.5" fill="#FF2E2E" fill-opacity="0.08"></rect>
															<path opacity="1" d="M11.667 19.8333C11.667 19.4167 12.0837 19 12.5003 19C12.917 19 13.3337 19.4167 13.3337 19.8333C13.3337 20.1111 13.3337 21.5 13.3337 24C13.3337 24.9205 14.0799 25.6667 15.0003 25.6667H25.0003C25.9208 25.6667 26.667 24.9205 26.667 24V19.8333C26.667 19.3731 27.0401 19 27.5003 19C27.9606 19 28.3337 19.3731 28.3337 19.8333V24C28.3337 25.8409 26.8413 27.3333 25.0003 27.3333H15.0003C13.1594 27.3333 11.667 25.8409 11.667 24C11.667 21.5 11.667 20.1111 11.667 19.8333Z" fill="#FD5353"></path>
															<path opacity="1" d="M20.8337 11.5C20.8337 11.0398 20.4606 10.6667 20.0003 10.6667C19.5401 10.6667 19.167 11.0398 19.167 11.5V21.5C19.167 21.9602 19.5401 22.3333 20.0003 22.3333C20.4606 22.3333 20.8337 21.9602 20.8337 21.5V11.5Z" fill="#FD5353"></path>
															<path d="M20.0302 11.815L16.4226 15.4226C16.0972 15.748 15.5695 15.748 15.2441 15.4226C14.9186 15.0972 14.9186 14.5695 15.2441 14.2441L19.4107 10.0774C19.7241 9.76402 20.228 9.75077 20.5575 10.0473L24.7241 13.7973C25.0662 14.1051 25.094 14.6321 24.7861 14.9741C24.4782 15.3162 23.9513 15.344 23.6092 15.0361L20.0302 11.815Z" fill="#FD5353"></path>
														</svg>	
													</span>
													Outcome
												</td>
												<td>Bangladesh,India</td>
												<td><span class=" btn btn-outline-success btn-xs">Completed</span></td>
												<td>
													<div class="dropdown">
														<a href="javascript:void(0);" class="btn-link btn sharp tp-btn-light btn-primary pill" data-bs-toggle="dropdown" aria-expanded="false">
														<svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.33319 9.99985C8.33319 10.9203 9.07938 11.6665 9.99986 11.6665C10.9203 11.6665 11.6665 10.9203 11.6665 9.99986C11.6665 9.07938 10.9203 8.33319 9.99986 8.33319C9.07938 8.33319 8.33319 9.07938 8.33319 9.99985Z" fill="#B9A8FF"></path>
														<path d="M8.33319 3.33329C8.33319 4.25376 9.07938 4.99995 9.99986 4.99995C10.9203 4.99995 11.6665 4.25376 11.6665 3.33329C11.6665 2.41282 10.9203 1.66663 9.99986 1.66663C9.07938 1.66663 8.33319 2.41282 8.33319 3.33329Z" fill="#B9A8FF"></path>
														<path d="M8.33319 16.6667C8.33319 17.5871 9.07938 18.3333 9.99986 18.3333C10.9203 18.3333 11.6665 17.5871 11.6665 16.6667C11.6665 15.7462 10.9203 15 9.99986 15C9.07938 15 8.33319 15.7462 8.33319 16.6667Z" fill="#B9A8FF"></path>
														</svg>
				
														</a>
														<div class="dropdown-menu dropdown-menu-end">
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M13.617 1.6665H6.39199C3.56699 1.6665 1.66699 3.64984 1.66699 6.59984V13.4082C1.66699 16.3498 3.56699 18.3332 6.39199 18.3332H13.617C16.442 18.3332 18.3337 16.3498 18.3337 13.4082V6.59984C18.3337 3.64984 16.442 1.6665 13.617 1.6665Z" fill="#FD5353"></path>
																<path d="M12.5129 11.4752L11.0304 9.99358L12.5121 8.51192C12.7971 8.22775 12.7971 7.76525 12.5121 7.48108C12.2271 7.19442 11.7663 7.19525 11.4813 7.48025L9.99878 8.96192L8.51628 7.47858C8.23128 7.19358 7.76961 7.19525 7.48461 7.47858C7.20044 7.76358 7.20044 8.22608 7.48461 8.51025L8.96794 9.99358L7.48794 11.4727C7.20294 11.7577 7.20294 12.2202 7.48794 12.5036C7.63044 12.6469 7.81628 12.7177 8.00294 12.7177C8.19044 12.7177 8.37628 12.6469 8.51878 12.5044L9.99878 11.0244L11.4821 12.5069C11.6246 12.6494 11.8104 12.7202 11.9971 12.7202C12.1838 12.7202 12.3704 12.6486 12.5129 12.5069C12.7979 12.2219 12.7979 11.7602 12.5129 11.4752Z" fill="#FD5353"></path>
																</svg> Cancel Transactions</a>
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M18.3337 9.99984C18.3337 14.6032 14.6028 18.3332 10.0003 18.3332C5.39783 18.3332 1.66699 14.6032 1.66699 9.99984C1.66699 5.39817 5.39783 1.6665 10.0003 1.6665C14.6028 1.6665 18.3337 5.39817 18.3337 9.99984Z" fill="#FF9F00"></path>
																<path fill-rule="evenodd" clip-rule="evenodd" d="M10.7249 10.5256C10.7249 10.9272 10.3974 11.2547 9.99577 11.2547C9.5941 11.2547 9.2666 10.9272 9.2666 10.5256V6.84225C9.2666 6.44058 9.5941 6.11308 9.99577 6.11308C10.3974 6.11308 10.7249 6.44058 10.7249 6.84225V10.5256ZM9.27077 13.1696C9.27077 12.7679 9.5966 12.4404 9.99577 12.4404C10.4066 12.4404 10.7333 12.7679 10.7333 13.1696C10.7333 13.5712 10.4066 13.8987 10.0041 13.8987C9.59993 13.8987 9.27077 13.5712 9.27077 13.1696Z" fill="#FF9F00"></path>
																</svg>
																 View Details</a>
														</div>
													</div>
												</td>
											</tr>	
											
											<tr>
												<td>
													<div class="checkbox mr-0 align-self-center">
														<div class="custom-control custom-checkbox ">
															<input type="checkbox" class="form-check-input" id="check811" required="">
															<label class="custom-control-label" for="check811"></label>
														</div>
													</div>
												</td>
												<td>#123412451</td>
												<td class="whitesp-no">June 1, 2020, 08:22 AM</td>
												<td class="whitesp-no p-0">
													<div class="d-flex py-sm-3 py-1 align-items-center">
														<span class=" me-3 rounded-3">
															<img src="images/avatar/LB.png" alt="" width="50" class="rounded-3 img-history">
														</span>
														<div>
															<h6 class="font-w500 fs-16 mb-0">Allison</h6>
															<span class="fs-14 font-w400"><a href="app-profile.html">Online Shop</a></span>
														</div>												
													</div>
												</td>
													
												
												<td class="whitesp-no amount"><a href="ecom-invoice.html">$128.89</a></td>
												<td class="income">
													<span class="me-2">
														<svg width="39" height="39" viewbox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect x="39" y="39" width="39" height="39" rx="19.5" transform="rotate(-180 39 39)" fill="#2BC155" fill-opacity="0.11"></rect>
															<path opacity="1" d="M11.667 19.8333C11.667 19.4167 12.0837 19 12.5003 19C12.917 19 13.3337 19.4167 13.3337 19.8333C13.3337 20.1111 13.3337 21.5 13.3337 24C13.3337 24.9205 14.0799 25.6667 15.0003 25.6667H25.0003C25.9208 25.6667 26.667 24.9205 26.667 24V19.8333C26.667 19.3731 27.0401 19 27.5003 19C27.9606 19 28.3337 19.3731 28.3337 19.8333V24C28.3337 25.8409 26.8413 27.3333 25.0003 27.3333H15.0003C13.1594 27.3333 11.667 25.8409 11.667 24C11.667 21.5 11.667 20.1111 11.667 19.8333Z" fill="#13C28F"></path>
															<path opacity="1" d="M19.1663 20.6667C19.1663 21.1269 19.5394 21.5 19.9997 21.5C20.4599 21.5 20.833 21.1269 20.833 20.6667V10.6667C20.833 10.2064 20.4599 9.83333 19.9997 9.83333C19.5394 9.83333 19.1663 10.2064 19.1663 10.6667V20.6667Z" fill="#13C28F"></path>
															<path d="M23.5774 16.7441C23.9028 16.4186 24.4305 16.4186 24.7559 16.7441C25.0814 17.0695 25.0814 17.5972 24.7559 17.9226L20.5893 22.0893C20.2759 22.4027 19.772 22.4159 19.4425 22.1194L15.2759 18.3694C14.9338 18.0615 14.906 17.5346 15.2139 17.1925C15.5218 16.8504 16.0487 16.8227 16.3908 17.1306L19.9698 20.3517L23.5774 16.7441Z" fill="#13C28F"></path>
														</svg>
													</span>
													 Income
												</td>
												<td>Bangladesh,India</td>
												<td><span class=" btn btn-outline-success btn-xs">Completed</span></td>
												<td>
													<div class="dropdown">
														<a href="javascript:void(0);" class="btn-link btn sharp tp-btn-light btn-primary pill" data-bs-toggle="dropdown" aria-expanded="false">
														<svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.33319 9.99985C8.33319 10.9203 9.07938 11.6665 9.99986 11.6665C10.9203 11.6665 11.6665 10.9203 11.6665 9.99986C11.6665 9.07938 10.9203 8.33319 9.99986 8.33319C9.07938 8.33319 8.33319 9.07938 8.33319 9.99985Z" fill="#B9A8FF"></path>
														<path d="M8.33319 3.33329C8.33319 4.25376 9.07938 4.99995 9.99986 4.99995C10.9203 4.99995 11.6665 4.25376 11.6665 3.33329C11.6665 2.41282 10.9203 1.66663 9.99986 1.66663C9.07938 1.66663 8.33319 2.41282 8.33319 3.33329Z" fill="#B9A8FF"></path>
														<path d="M8.33319 16.6667C8.33319 17.5871 9.07938 18.3333 9.99986 18.3333C10.9203 18.3333 11.6665 17.5871 11.6665 16.6667C11.6665 15.7462 10.9203 15 9.99986 15C9.07938 15 8.33319 15.7462 8.33319 16.6667Z" fill="#B9A8FF"></path>
														</svg>
				
														</a>
														<div class="dropdown-menu dropdown-menu-end">
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M13.617 1.6665H6.39199C3.56699 1.6665 1.66699 3.64984 1.66699 6.59984V13.4082C1.66699 16.3498 3.56699 18.3332 6.39199 18.3332H13.617C16.442 18.3332 18.3337 16.3498 18.3337 13.4082V6.59984C18.3337 3.64984 16.442 1.6665 13.617 1.6665Z" fill="#FD5353"></path>
																<path d="M12.5129 11.4752L11.0304 9.99358L12.5121 8.51192C12.7971 8.22775 12.7971 7.76525 12.5121 7.48108C12.2271 7.19442 11.7663 7.19525 11.4813 7.48025L9.99878 8.96192L8.51628 7.47858C8.23128 7.19358 7.76961 7.19525 7.48461 7.47858C7.20044 7.76358 7.20044 8.22608 7.48461 8.51025L8.96794 9.99358L7.48794 11.4727C7.20294 11.7577 7.20294 12.2202 7.48794 12.5036C7.63044 12.6469 7.81628 12.7177 8.00294 12.7177C8.19044 12.7177 8.37628 12.6469 8.51878 12.5044L9.99878 11.0244L11.4821 12.5069C11.6246 12.6494 11.8104 12.7202 11.9971 12.7202C12.1838 12.7202 12.3704 12.6486 12.5129 12.5069C12.7979 12.2219 12.7979 11.7602 12.5129 11.4752Z" fill="#FD5353"></path>
																</svg> Cancel Transactions</a>
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M18.3337 9.99984C18.3337 14.6032 14.6028 18.3332 10.0003 18.3332C5.39783 18.3332 1.66699 14.6032 1.66699 9.99984C1.66699 5.39817 5.39783 1.6665 10.0003 1.6665C14.6028 1.6665 18.3337 5.39817 18.3337 9.99984Z" fill="#FF9F00"></path>
																<path fill-rule="evenodd" clip-rule="evenodd" d="M10.7249 10.5256C10.7249 10.9272 10.3974 11.2547 9.99577 11.2547C9.5941 11.2547 9.2666 10.9272 9.2666 10.5256V6.84225C9.2666 6.44058 9.5941 6.11308 9.99577 6.11308C10.3974 6.11308 10.7249 6.44058 10.7249 6.84225V10.5256ZM9.27077 13.1696C9.27077 12.7679 9.5966 12.4404 9.99577 12.4404C10.4066 12.4404 10.7333 12.7679 10.7333 13.1696C10.7333 13.5712 10.4066 13.8987 10.0041 13.8987C9.59993 13.8987 9.27077 13.5712 9.27077 13.1696Z" fill="#FF9F00"></path>
																</svg>
																 View Details</a>
														</div>
													</div>
												</td>
												
											</tr>
											<tr>
												<td>
													<div class="checkbox mr-0 align-self-center">
														<div class="custom-control custom-checkbox ">
															<input type="checkbox" class="form-check-input" id="check822" required="">
															<label class="custom-control-label" for="check822"></label>
														</div>
													</div>
												</td>
												<td>#123412451</td>
												<td class="whitesp-no">June 1, 2020, 08:22 AM</td>
												<td class="whitesp-no p-0">
													<div class="d-flex py-sm-3 py-1 align-items-center">
														<span class=" me-3">
															<img src="images/avatar/LB.png" alt="" width="50" class="rounded-3 img-history">
														</span>
														<div>
															<h6 class="font-w500 fs-16 mb-0">Yellow Studios</h6>
															<span class="fs-14 font-w400"><a href="app-profile.html">Studio</a></span>
														</div>												
													</div>
												</td>
												<td class="whitesp-no amount">
													<a href="ecom-invoice.html">$128.89</a>
												</td>
												<td class="income">
													<span class="me-2">
														<svg width="39" height="39" viewbox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect width="39" height="39" rx="19.5" fill="#FF2E2E" fill-opacity="0.08"></rect>
															<path opacity="1" d="M11.667 19.8333C11.667 19.4167 12.0837 19 12.5003 19C12.917 19 13.3337 19.4167 13.3337 19.8333C13.3337 20.1111 13.3337 21.5 13.3337 24C13.3337 24.9205 14.0799 25.6667 15.0003 25.6667H25.0003C25.9208 25.6667 26.667 24.9205 26.667 24V19.8333C26.667 19.3731 27.0401 19 27.5003 19C27.9606 19 28.3337 19.3731 28.3337 19.8333V24C28.3337 25.8409 26.8413 27.3333 25.0003 27.3333H15.0003C13.1594 27.3333 11.667 25.8409 11.667 24C11.667 21.5 11.667 20.1111 11.667 19.8333Z" fill="#FD5353"></path>
															<path opacity="1" d="M20.8337 11.5C20.8337 11.0398 20.4606 10.6667 20.0003 10.6667C19.5401 10.6667 19.167 11.0398 19.167 11.5V21.5C19.167 21.9602 19.5401 22.3333 20.0003 22.3333C20.4606 22.3333 20.8337 21.9602 20.8337 21.5V11.5Z" fill="#FD5353"></path>
															<path d="M20.0302 11.815L16.4226 15.4226C16.0972 15.748 15.5695 15.748 15.2441 15.4226C14.9186 15.0972 14.9186 14.5695 15.2441 14.2441L19.4107 10.0774C19.7241 9.76402 20.228 9.75077 20.5575 10.0473L24.7241 13.7973C25.0662 14.1051 25.094 14.6321 24.7861 14.9741C24.4782 15.3162 23.9513 15.344 23.6092 15.0361L20.0302 11.815Z" fill="#FD5353"></path>
														</svg>
	
													</span>
													Outcome
												</td>
												<td>Bangladesh,India</td>
												<td><span class="btn btn-outline-success btn-xs">Completed</span></td>
												<td>
													<div class="dropdown">
														<a href="javascript:void(0);" class="btn-link btn sharp tp-btn-light btn-primary pill" data-bs-toggle="dropdown" aria-expanded="false">
														<svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M8.33319 9.99985C8.33319 10.9203 9.07938 11.6665 9.99986 11.6665C10.9203 11.6665 11.6665 10.9203 11.6665 9.99986C11.6665 9.07938 10.9203 8.33319 9.99986 8.33319C9.07938 8.33319 8.33319 9.07938 8.33319 9.99985Z" fill="#B9A8FF"></path>
														<path d="M8.33319 3.33329C8.33319 4.25376 9.07938 4.99995 9.99986 4.99995C10.9203 4.99995 11.6665 4.25376 11.6665 3.33329C11.6665 2.41282 10.9203 1.66663 9.99986 1.66663C9.07938 1.66663 8.33319 2.41282 8.33319 3.33329Z" fill="#B9A8FF"></path>
														<path d="M8.33319 16.6667C8.33319 17.5871 9.07938 18.3333 9.99986 18.3333C10.9203 18.3333 11.6665 17.5871 11.6665 16.6667C11.6665 15.7462 10.9203 15 9.99986 15C9.07938 15 8.33319 15.7462 8.33319 16.6667Z" fill="#B9A8FF"></path>
														</svg>
				
														</a>
														<div class="dropdown-menu dropdown-menu-end">
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M13.617 1.6665H6.39199C3.56699 1.6665 1.66699 3.64984 1.66699 6.59984V13.4082C1.66699 16.3498 3.56699 18.3332 6.39199 18.3332H13.617C16.442 18.3332 18.3337 16.3498 18.3337 13.4082V6.59984C18.3337 3.64984 16.442 1.6665 13.617 1.6665Z" fill="#FD5353"></path>
																<path d="M12.5129 11.4752L11.0304 9.99358L12.5121 8.51192C12.7971 8.22775 12.7971 7.76525 12.5121 7.48108C12.2271 7.19442 11.7663 7.19525 11.4813 7.48025L9.99878 8.96192L8.51628 7.47858C8.23128 7.19358 7.76961 7.19525 7.48461 7.47858C7.20044 7.76358 7.20044 8.22608 7.48461 8.51025L8.96794 9.99358L7.48794 11.4727C7.20294 11.7577 7.20294 12.2202 7.48794 12.5036C7.63044 12.6469 7.81628 12.7177 8.00294 12.7177C8.19044 12.7177 8.37628 12.6469 8.51878 12.5044L9.99878 11.0244L11.4821 12.5069C11.6246 12.6494 11.8104 12.7202 11.9971 12.7202C12.1838 12.7202 12.3704 12.6486 12.5129 12.5069C12.7979 12.2219 12.7979 11.7602 12.5129 11.4752Z" fill="#FD5353"></path>
																</svg> Cancel Transactions</a>
															<a class="dropdown-item" href="javascript:void(0);"><svg width="20" height="20" viewbox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M18.3337 9.99984C18.3337 14.6032 14.6028 18.3332 10.0003 18.3332C5.39783 18.3332 1.66699 14.6032 1.66699 9.99984C1.66699 5.39817 5.39783 1.6665 10.0003 1.6665C14.6028 1.6665 18.3337 5.39817 18.3337 9.99984Z" fill="#FF9F00"></path>
																<path fill-rule="evenodd" clip-rule="evenodd" d="M10.7249 10.5256C10.7249 10.9272 10.3974 11.2547 9.99577 11.2547C9.5941 11.2547 9.2666 10.9272 9.2666 10.5256V6.84225C9.2666 6.44058 9.5941 6.11308 9.99577 6.11308C10.3974 6.11308 10.7249 6.44058 10.7249 6.84225V10.5256ZM9.27077 13.1696C9.27077 12.7679 9.5966 12.4404 9.99577 12.4404C10.4066 12.4404 10.7333 12.7679 10.7333 13.1696C10.7333 13.5712 10.4066 13.8987 10.0041 13.8987C9.59993 13.8987 9.27077 13.5712 9.27077 13.1696Z" fill="#FF9F00"></path>
																</svg>
																 View Details</a>
														</div>
													</div>
												</td>
											</tr>
																		
										</tbody>
									</table>
								</div>
							</div>
				
							<!----/column-- -->	
							<!----column-- -->	
							
						<!--/row-->
					</div>
					<!--/column-->
					<!--column-->
				
					<!----/column-- -->
				</div>
				<!--**********************************
				Footer start
			***********************************-->
				<div class="footer">
					<div class="copyright">
						<p>Copyright TOPGAIN © Designed &amp; Developed by <a href="https://sasaviltech.com" target="_blank">SASAVIL TECH</a> 2023</p>
					</div>
				</div>
			<!--**********************************
				Footer end
			***********************************-->

        	</div>
			<!-- Modal -->
		
			<!-- /Modal -->	
		</div>		
        <!--**********************************
            Content body end
        ***********************************-->
		
			
		
		<!--**********************************
           Support ticket button start
        ***********************************-->
		
        <!--**********************************
           Support ticket button end
        ***********************************-->
	

</div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="vendor/global/global.min-1.js"></script>
	<script src="vendor/chart.js/Chart.bundle.min-1.js"></script>
	<script src="vendor/jquery-nice-select/js/jquery.nice-select.min-1.js"></script> 
	<!-- Apex Chart -->
	<script src="vendor/apexchart/apexchart-1.js"></script>
	<!-- Chart piety plugin files -->
    <script src="vendor/peity/jquery.peity.min-1.js"></script> 
	<!-- Chartist -->
   <script src="vendor/chartist/js/chartist.min-1.js"></script> 
   <script src="vendor/jquery-autocomplete/jquery-ui-1.js"></script> 
	<!-- <script src="./js/dashboard/dashboard-2.js"></script> -->
	<!-- Dashboard 1 -->
	<script src="js/dashboard/dashboard-1-1.js"></script>
	<script src="js/custom.min-1.js"></script>
	<script src="js/dlabnav-init-1.js"></script>
	<script src="js/demo-1.js"></script>
    <script src="js/styleSwitcher-1.js"></script>
	
</body>
</html>
<?php /**PATH /home/perfectm/topgainagencies.com/resources/views/carhirehistory.blade.php ENDPATH**/ ?>