<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\invest;
use App\Http\Middleware\withdraw;
use App\Http\Middleware\accStatus;
use Illuminate\Support\Facades\Http;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('display');
});
Route::get('/about', function () {
    return view('about');
});


Route::get('/contact', function () {
    return view('contact');
});




Route::get('/forgotpassword', [App\Http\Controllers\DetailsController::class, 'forgotpass'])->name('forgotpass');


Route::post('/forgotpasstore', [App\Http\Controllers\DetailsController::class, 'forgotpasstore'])->name('forgotpasstore');

Route::get('/passrecovery', [App\Http\Controllers\DetailsController::class, 'passrecovery'])->name('passrecovery');
Route::post('/passrecoverystore', [App\Http\Controllers\DetailsController::class, 'passrecoverystore'])->name('passrecoverystore');


Route::get('/getdata', [App\Http\Controllers\DetailsController::class, 'connect'])->name('getdata');
Route::get('/noconnection', [App\Http\Controllers\HomeController::class, 'noconnection'])->name('noconnection');


Route::get('/wifihotspot', [App\Http\Controllers\DetailsController::class, 'wifihotspot'])->name('wifihotspot');

Route::post('/receiveIp', [App\Http\Controllers\DetailsController::class, 'receiveIp'])->name(' receiveIp');
Route::post('/paynow', [App\Http\Controllers\DetailsController::class, 'wifihotspotuserpay'])->name('wifihotspotuserpay');
Route::post('/processpayment', [App\Http\Controllers\DetailsController::class, 'processPayment'])->name('process.payment');
Route::get('/check-payment-status', [App\Http\Controllers\DetailsController::class, 'checkPaymentStatus'])->name('check-payment-status');
Route::get('/user/userconnection', [App\Http\Controllers\DetailsController::class, 'userconnection'])->name('userconnection');

Route::get('/user/testdeposit', [App\Http\Controllers\MpesaController::class, 'testdeposit'])->name('testdeposit');
Route::get('/user/registerurl', [App\Http\Controllers\MpesaController::class, 'registerurl'])->name('registerurl');


Route::get('/user/userconnectiontest', [App\Http\Controllers\DetailsController::class, 'userconnectiontest'])->name('userconnectiontest');
Route::post('/activaehotspotuservoucher', [App\Http\Controllers\DetailsController::class, 'activaehotspotuservoucher'])->name('activaehotspotuservoucher');
Route::get('/user/userdashboard', [App\Http\Controllers\DetailsController::class, 'userdashboard'])->name('userdashboard');
Route::post('/userlogin', [App\Http\Controllers\DetailsController::class, 'userlogin'])->name('userlogin');

Auth::routes();

//Route::get('register/{referral_token}', 'Auth\RegisterController@showRegistrationForm');
Route::get('register/{referral_token}', [App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm']);

Route::get('/user/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard');
Route::group(['prefix'=>'/','middleware'=>['auth','accesstf']],function () {


Route::get('/inactive', [App\Http\Controllers\HomeController::class, 'inactive'])->name('inactive');



Route::get('/user/interfaces', [App\Http\Controllers\HomeController::class, 'interfaces'])->name('interfaces');


Route::get('/user/sendsinglesms', [App\Http\Controllers\HomeController::class, 'sendsinglesms'])->name('sendsinglesms');
  Route::get('/user/sendgroupsms', [App\Http\Controllers\HomeController::class, 'sendgroupsms'])->name('sendgroupsms');

Route::post('/user/sendsinglesmsstore', [App\Http\Controllers\HomeController::class, 'sendsinglesmsstore'])->name('sendsinglesmsstore');
  Route::post('/user/sendgroupsmsstore', [App\Http\Controllers\HomeController::class, 'sendgroupsmsstore'])->name('sendgroupsmsstore');





Route::get('/user/addrouter', [App\Http\Controllers\HomeController::class, 'addrouter'])->name('addrouter');

Route::get('/user/allrouters', [App\Http\Controllers\HomeController::class, 'allrouters'])->name('allrouters');

Route::get('/user/createpackages', [App\Http\Controllers\HomeController::class, 'createdpackages'])->name('createpackages');
Route::get('/user/createppoepackages', [App\Http\Controllers\HomeController::class, 'createppoepackages'])->name('createppoepackages');
  Route::get('/user/getppoepackages', [App\Http\Controllers\HomeController::class, 'getppoepackages'])->name('getppoepackages');
   Route::get('/user/editppoepackages', [App\Http\Controllers\HomeController::class, 'editppoepackages'])->name('editppoepackages');
 Route::post('/user/editppoepackagespost', [App\Http\Controllers\HomeController::class, 'editppoepackagespost'])->name('editppoepackagespost');
  Route::get('/user/pppoeanalytics', [App\Http\Controllers\HomeController::class, 'pppoeanalytics'])->name('pppoeanalytics');
  Route::get('/user/hotspotanalytics', [App\Http\Controllers\HomeController::class, 'hotspotanalytics'])->name('hotspotanalytics');

  
  Route::get('/user/pppoeanalyticsuserStats', [App\Http\Controllers\HomeController::class, 'pppoeanalyticsuserStats'])->name('pppoeanalyticsuserStats');
 Route::get('/user/hotspotanalyticsuserStats', [App\Http\Controllers\HomeController::class, 'hotspotanalyticsuserStats'])->name('hotspotanalyticsuserStats');

  Route::get('/user/createppoepayment', [App\Http\Controllers\HomeController::class, 'createppoepayment'])->name('createppoepayment');
  Route::post('/user/createppoepaymentpost', [App\Http\Controllers\HomeController::class, 'createppoepaymentpost'])->name('createppoepaymentpost');
  
   Route::get('/user/hotspotpageconfig', [App\Http\Controllers\HomeController::class, 'hotspotpageconfig'])->name('hotspotpageconfig');
   Route::post('/user/hotspotpageconfigpost', [App\Http\Controllers\HomeController::class, 'hotspotpageconfigpost'])->name('hotspotpageconfigpost');
  
  Route::post('/user/createppoepackagespost', [App\Http\Controllers\HomeController::class, 'createppoepackagespost'])->name('createppoepackagespost');


Route::post('/user/createdpackagespost', [App\Http\Controllers\HomeController::class, 'createdpackagespost'])->name('createdpackagespost');

Route::get('/user/allpackages', [App\Http\Controllers\HomeController::class, 'allpackages'])->name('allpackages');
Route::get('/user/editpackages', [App\Http\Controllers\HomeController::class, 'editpackages'])->name('editpackages');
Route::post('/user/editpackagespost', [App\Http\Controllers\HomeController::class, 'editpackagespost'])->name('editpackagespost');



Route::post('/user/addrouterpost', [App\Http\Controllers\HomeController::class, 'addrouterpost'])->name('addrouterpost');



Route::get('/user/editinterfaces', [App\Http\Controllers\HomeController::class, 'editinterfaces'])->name('editinterfaces');


Route::post('/user/editinterfacesstore', [App\Http\Controllers\HomeController::class, 'editinterfacesstore'])->name('editinterfacesstore');


Route::get('/user/routerlogs', [App\Http\Controllers\HomeController::class, 'routerlogs'])->name('routerlogs');
Route::get('/user/mpesapayments', [App\Http\Controllers\HomeController::class, 'mpesapayments'])->name('mpesapayments');
Route::get('/user/dailympesapayments', [App\Http\Controllers\HomeController::class, 'dailympesapayments'])->name('dailympesapayments');
  
  
Route::get('/user/wifiusers', [App\Http\Controllers\HomeController::class, 'wifiusers'])->name('wifiusers');
Route::get('/user/activewifiusers', [App\Http\Controllers\HomeController::class, 'activewifiusers'])->name('activewifiusers');
Route::get('/user/pppoe/createpppoe', [App\Http\Controllers\HomeController::class, 'createpppoe'])->name('createpppoe');
  Route::post('/user/pppoe/createpppoestore', [App\Http\Controllers\HomeController::class, 'createpppoestore'])->name('createpppoestore');
Route::get('/user/pppoe/allpppoe', [App\Http\Controllers\HomeController::class, 'allpppoe'])->name('allpppoe');
  Route::get('/user/pppoe/editppoeusers', [App\Http\Controllers\HomeController::class, 'editppoeusers'])->name('editppoeusers');
    Route::post('/user/pppoe/editppoeusersstore', [App\Http\Controllers\HomeController::class, 'editppoeusersstore'])->name('editppoeusersstore');
  
 Route::get('/pppoe-users', [App\Http\Controllers\HomeController::class, 'fetchPppoeUsers'])->name('fetchPppoeUsers'); 
   Route::get('/fetchhotspotusers', [App\Http\Controllers\HomeController::class, 'fetchhotspotusers'])->name('fetchhotspotusers'); 

});
Route::get('/inactive', [App\Http\Controllers\HomeController::class, 'inactive'])->name('inactive');




///admin start





Route::Post('mpesapay', [App\Http\Controllers\HomeController::class,'mpesapay'])->name('mpesapay');
Route::Post('manualactivate', [App\Http\Controllers\HomeController::class,'manualactivate'])->name('manual.activate');





//Route::post('invest', 'HomeController@storeinvest')->name('invest');
///start of mpesa
Route::get('/pay', [App\Http\Controllers\HomeController::class, 'pay'])->name('pay');

Route::get('/confirm', function () {
    return view('confirm');
});
//Route::post('/confirm', '[App\Http\Controllers\MpesaController::class, 'confirm'])->name('confirm');
Route::post('/confirm', [App\Http\Controllers\MpesaController::class, 'confirm'])->name('confirm');
//Route::post('/confirm', [App\Http\Controllers\CoinbaseController::class, 'process'])->name('confirm');
Route::post('/stk/push', [App\Http\Controllers\MpesaController::class, 'stkPush'])->name('lipa');