HTML
<!DOCTYPE html>
<html>
<head>
    <title>Aviator Game</title>
    <link rel="stylesheet" href="style.css">
    <style>
    .game-container {
    width: 100%;
    height: 600px;
    border: 1px solid #333;
    position: relative;
    overflow: hidden;
}

.plane {
    width: 50px;
    height: 50px;
    background-image: url('assets/downloadmpesa.png'); /* Replace with your plane image */
    position: absolute;
    bottom: 0;
    left: 50%;
    transform: translateX(-50%);
}

.multiplier {
    font-size: 24px;
    position: absolute;
    top: 10px;
    right: 10px;
}

.cashout-button {
    position: absolute;
    bottom: 10px;
    right: 10px;
    padding: 10px 20px;
    background-color: #00ff00;
    color: #fff;
    border: none;
    cursor: pointer;
}

.betting-interface {
    position: absolute;
    bottom: 10px;
    left: 10px;
}
    </style>
</head>
<body>
    <div class="game-container">
        <div class="plane"></div>
        <div class="multiplier">1x</div>
        <button class="cashout-button">Cashout</button>
        <div class="betting-interface">
            <input type="number" id="bet-amount" placeholder="Bet Amount">
            <button id="bet-button">Bet</button>
        </div>
    </div>
    <script src="script.js"></script>
    <script>
    const plane = document.querySelector('.plane');
const multiplier = document.querySelector('.multiplier');
const cashoutButton = document.querySelector('.cashout-button');
const betAmountInput = document.getElementById('bet-amount');
const betButton = document.getElementById('bet-button');

let multiplierValue = 1;
let isFlying = false;

function startGame() {
    if (!isFlying) {
        isFlying = true;
        const intervalId = setInterval(() => {
            multiplierValue += 0.1;
            multiplier.textContent = multiplierValue.toFixed(2) + 'x';
            plane.style.top = (400- multiplierValue * 2) + 'px';

            if (multiplierValue >= 100) {
                clearInterval(intervalId);
                isFlying = false;
                alert('Plane crashed! You lost your bet.');
            }
        }, 100);
    }
}

cashoutButton.addEventListener('click', () => {
    if (isFlying) {
        clearInterval(intervalId);
        isFlying = false;
        alert('You cashed out at ' + multiplierValue.toFixed(2) + 'x!');
    }
});

betButton.addEventListener('click', () => {
    const betAmount = parseFloat(betAmountInput.value);
    if (!isNaN(betAmount) && betAmount > 0) {
        // Implement betting logic here
        startGame();
    } else {
        alert('Please enter a valid bet amount.');
    }
});
    </script>
</body>
</html>