﻿<!DOCTYPE html>
<html lang="en">
<head>
	
	<!-- Title -->
	<title>Wedo - Ecommerce Mobile App Template ( Bootstrap + PWA )</title>

	<!-- Meta -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
	<meta name="theme-color" content="#FE4487">
	<meta name="author" content="DexignZone">
	<meta name="robots" content="index, follow"> 
	<meta name="keywords" content="android, ios, mobile, application template, progressive web app, ui kit, multiple color, dark layout">
	<meta name="description" content="Revolutionize your online store with our Ecommerce App Template. Seamless shopping, secure payments, and personalized recommendations for an exceptional user experience">
	<meta property="og:title" content="Wedo - Ecommerce Mobile App Template ( Bootstrap + PWA )">
	<meta property="og:description" content="Revolutionize your online store with our Ecommerce App Template. Seamless shopping, secure payments, and personalized recommendations for an exceptional user experience.">
	<meta property="og:image" content="https://wedo.dexignzone.com/xhtml/social-image.png">
	<meta name="format-detection" content="telephone=no">

	<!-- Favicons Icon -->
	<link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.png">
	
	<!-- PWA Version -->
	<link rel="manifest" href="manifest.json">
    
    <!-- Global CSS -->
	<link href="assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
	<link rel="stylesheet" href="assets/vendor/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.css">
	<link rel="stylesheet" href="assets/vendor/swiper/swiper-bundle.min.css">
    
	<!-- Stylesheets -->
    <link rel="stylesheet" class="main-css" type="text/css" href="assets/css/style.css">
	
    <!-- Google Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
	<link href="../css2.css?family=Open+Sans:wght@300;400;500;600;700;800&family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

</head>   
<body>
<div class="page-wrapper">
    
	<!-- Preloader -->
	<div id="preloader">
		<div class="loader">
			<div class="load-circle"><div></div><div></div></div>
		</div>
	</div> 
    <!-- Preloader end-->
	
	<!-- Header -->
		<header class="header header-fixed">
			<div class="container">
				<div class="header-content">
					<div class="left-content">
						<a href="javascript:void(0);" class="menu-toggler">
							<i class="icon feather icon-menu"></i>
						</a>
					
					</div>
					<div class="mid-content header-logo">
					    <img style="height:50px" src="/images/logo.png">
					</div>
					<div class="right-content dz-meta">
					<h11 style="height:14px;color:blue">Welcome <?php echo e(auth()->user()->name); ?></h11>
					
					
					</div>
				</div>
			</div>
		</header>
	<!-- Header -->
	
	<!-- Sidebar -->
    <div class="dark-overlay"></div>
	<div class="sidebar">
		<div class="inner-sidebar">
			<a href="profile.html" class="author-box">
				<div class="dz-media">
					<img src="assets/images/user-profile.jpg" alt="author-image">
				</div>
				<div class="dz-info">
					<h5 class="name">John Doe</h5>
					<span>example@gmail.com</span>
				</div>
			</a>
			<ul class="nav navbar-nav">	
				<li>
					<a class="nav-link active" href="index.html">
						<span class="dz-icon">
							<i class="icon feather icon-home"></i>
						</span>
						<span>Home</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="product-list.html">
						<span class="dz-icon">
							<i class="icon feather icon-layers"></i>
						</span>
						<span>Products</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="components.html">
						<span class="dz-icon">
							<i class="icon feather icon-grid"></i>
						</span>
						<span>Components</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="pages.html">
						<span class="dz-icon">
							<i class="icon feather icon-book-open"></i>
						</span>
						<span>Pages</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="featured.html">
						<span class="dz-icon">
							<i class="icon feather icon-list"></i>
						</span>
						<span>Featured</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="wishlist.html">
						<span class="dz-icon">
							<i class="icon feather icon-heart"></i>
						</span>
						<span>Wishlist</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="order.html">
						<span class="dz-icon">
							<i class="icon feather icon-repeat"></i>
						</span>
						<span>Orders</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="cart.html">
						<span class="dz-icon">
							<i class="icon feather icon-shopping-cart"></i>
						</span>
						<span>My Cart</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="profile.html">
						<span class="dz-icon">
							<i class="icon feather icon-user"></i>
						</span>
						<span>Profile</span>
					</a>
				</li>
				<li>
					<a class="nav-link" href="onboarding.html">
						<span class="dz-icon">
							<i class="icon feather icon-log-out"></i>
						</span>
						<span>Logout</span>
					</a>
				</li>
			</ul>
			<div class="sidebar-bottom">
				<ul class="app-setting">
					<li class="nav-color">
						<a href="javascript:void(0);" data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom" aria-controls="offcanvasBottom">
							<span class="dz-icon">                        
								<svg class="color-plate" width="20" height="20" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M10.725.787a9.325 9.325 0 0 1 	8.425 7.65 2.35 2.35 0 0 1-.625 2.275 1.662 1.662 0 0 1-1.863.188c-.462-.225-.812-.6-1.25-.788a4.238 4.238 0 0 0-4.5.725A3.751 3.751 0 0 0 10 14.825c.237.725.75 1.25 1.012 1.987a1.713 1.713 0 0 1-.762 2.063 3.312 3.312 0 0 1-2.5.125A9.262 9.262 0 0 1 3.125 3.837a9.2 9.2 0 0 1 7.6-3.05zM2.162 11.6A8.112 8.112 0 0 0 8 17.85c.487.125 1.25.3 1.6 0 .35-.3.15-.9-.125-1.25a4.674 4.674 0 0 1-.725-1.388A5 5 0 0 1 10 9.925a5.187 5.187 0 0 1 3.6-1.4 5.063 5.063 0 0 1 3.137 1.025.887.887 0 0 0 .95.225c.4-.213.338-.75.263-1.125a8.413 8.413 0 0 0-1.963-3.95 8.087 8.087 0 0 0-11.937 0 8.075 8.075 0 0 0-1.9 6.9h.012z"></path><path d="M14.313 4.862a1.575 1.575 0 1 1 .024 3.15 1.575 1.575 0 0 1-.024-3.15zm0 2.2a.637.637 0 1 0 0-1.274.637.637 0 0 0 0 1.274zm-4.075-4.075a1.575 1.575 0 1 1 0 3.15 1.575 1.575 0 0 1 0-3.15zm0 2.2a.637.637 0 1 0 0-1.274.637.637 0 0 0 0 1.274zM6.25 7.925a1.575 1.575 0 1 1 .025-3.15 1.575 1.575 0 0 1-.025 3.15zm0-2.2A.637.637 0 1 0 6.25 7a.637.637 0 0 0 0-1.275zm.125 4.675a1.575 1.575 0 1 1-3.15 0 1.575 1.575 0 0 1 3.15 0zm-2.2 0a.638.638 0 1 0 1.275 0 .638.638 0 0 0-1.275 0zm2.075 2.387a1.575 1.575 0 1 1 0 3.151 1.575 1.575 0 0 1 0-3.15zm0 2.213a.638.638 0 1 0 0-1.276.638.638 0 0 0 0 1.276z"></path>
								</svg>
							</span>					
							<span>Color Theme</span>
							<div class="color-active ms-auto">
								<span>Active</span>	
								<div class="current-color"></div>
							</div>	
						</a>
					</li>
					<li>
						<div class="mode">
							<span class="dz-icon">                        
								<i class="icon feather icon-moon"></i>
							</span>					
							<span>Dark Mode</span>
							<div class="custom-switch">
								<input type="checkbox" class="switch-input theme-btn" id="toggle-dark-menu">
								<label class="custom-switch-label" for="toggle-dark-menu"></label>
							</div>					
						</div>
					</li>
					<li>
						<div class="mode">
							<span class="dz-icon">                        
								<i class="fa-solid fa-arrows-left-right"></i>
							</span>					
							<span>Lyout (LTR/RTL)</span>
							<div class="custom-switch">
								<input type="checkbox" class="switch-input direction-btn" id="direction-btn">
								<label class="custom-switch-label" for="direction-btn"></label>
							</div>					
						</div>
					</li>
				</ul>
				<div class="app-info">
					<h6 class="name">Wedo Fashion Store App</h6>
					<span class="ver-info">App Version 1.0</span>
				</div>
			</div>
		</div>
	</div>
    <!-- Sidebar End -->
	
	<!-- Page Content Start -->
	<div class="page-content space-top p-b65">
		<div class="container py-0">
			<!-- Banner -->
			<div class="dz-banner">
				<div class="swiper banner-swiper">
					<div class="swiper-wrapper">
						<div class="swiper-slide">
							<div class="dz-media">
								<img src="assets/images/banner/pic1.png" alt="">
							</div>	
						</div>
						<div class="swiper-slide">
							<div class="dz-media">
								<img src="assets/images/banner/pic2.png" alt="">
							</div>	
						</div>
						<div class="swiper-slide">
							<div class="dz-media">
								<img src="assets/images/banner/pic3.png" alt="">
							</div>	
						</div>
					</div>
					<div class="swiper-pagination style-2"></div>
				</div>
			</div>
			<!-- Banner End -->
			
			<!-- Catagory Start -->
			<div class="category-area">
				<ul class="row g-3">
					<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
							<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M211.5 595.5l434.2-434.2c18.4-18.4 48.3-18.4 66.8 0L946.2 395c18.4 18.4 18.4 48.3 0 66.8L545.4 862.6c-18.4 18.4-48.3 18.4-66.8 0L211.5 595.5z" fill="#FFEA00"></path><path d="M478.6 862.6L77.8 461.9c-18.4-18.4-18.4-48.3 0-66.8l233.7-233.7c18.4-18.4 48.3-18.4 66.8 0l400.8 400.8c18.4 18.4 18.4 48.3 0 66.8L545.4 862.6c-18.5 18.5-48.3 18.5-66.8 0z" fill="#536DFE"></path><path d="M345 729.1L77.8 461.9c-18.4-18.4-18.4-48.3 0-66.8l233.7-233.7c18.4-18.4 48.3-18.4 66.8 0l400.8 400.8L345 729.1z" fill="#3D5AFE"></path><path d="M294.8 344.9c-9.2-9.2-9.2-24.2 0-33.4L411.3 195c55.5-55.5 145.4-55.5 200.9 0L462.3 344.9c-46.3 46.2-121.3 46.2-167.5 0z" fill="#FFEA00"></path></g></svg>
							<span>Assets</span>
							<span>KES303011</span>
						</div>
					</li>
					<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
							<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M242.3 743.4h603.4c27.8 0 50.3-22.5 50.3-50.3V192H192v501.1c0 27.8 22.5 50.3 50.3 50.3z" fill="#FFEA00"></path><path d="M178.3 807.4h603.4c27.8 0 50.3-22.5 50.3-50.3V256H128v501.1c0 27.8 22.5 50.3 50.3 50.3z" fill="#FFFF8D"></path><path d="M960 515v384c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V383.8c0-35.3 28.7-64 64-64h344.1c24.5 0 46.8 13.9 57.5 35.9l46.5 95.3H896c35.3 0 64 28.7 64 64z" fill="#3D5AFE"></path><path d="M704 512c0-20.7-1.4-41.1-4.1-61H576.1l-46.5-95.3c-10.7-22-33.1-35.9-57.5-35.9H128c-35.3 0-64 28.7-64 64V899c0 6.7 1 13.2 3 19.3C124.4 945 188.5 960 256 960c247.4 0 448-200.6 448-448z" fill="#536DFE"></path></g></svg>
						
							<span>Balance</span>
							<span>KES203011</span>
						</div>
					</li>
					<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
							<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M928 480c-17.7 0-32 14.3-32 32 0 211.7-172.3 384-384 384-8 0-16-0.3-23.9-0.7-32.2 19.6-67.2 35.2-104.1 46.2 41.4 12.3 84.4 18.6 128 18.6 60.5 0 119.1-11.8 174.4-35.2 53.4-22.6 101.3-54.9 142.4-96 41.1-41.1 73.4-89 96-142.4 23.4-55.4 35.2-114 35.2-174.5 0-17.7-14.3-32-32-32z" fill="#3D5AFE"></path><path d="M512 128c17.7 0 32-14.3 32-32s-14.3-32-32-32c-43.8 0-86.7 6.2-128 18.5 36.9 11 71.9 26.6 104.1 46.2 7.9-0.4 15.9-0.7 23.9-0.7zM617.8 247.8l61.5-61.5-79.1-79.3-59.2 59.2c28.8 23.9 54.7 51.3 76.8 81.6zM692.5 613.2l26.3 8.8L917 423.8l-79.2-79.2-118.7 118.7-18.4-6.2c2.2 18 3.3 36.3 3.3 54.8 0 34.9-4 68.8-11.5 101.3zM393.5 877.4c-16.8-5.4-34.9 3.8-40.3 20.6s3.8 34.9 20.6 40.3c3.4 1.1 6.8 2.1 10.2 3.2 36.9-11 71.8-26.6 104.1-46.2-32.3-2-64-8-94.6-17.9z" fill="#FFEA00"></path><path d="M195.2 195.2c-41.1 41.1-73.4 89-96 142.4C75.8 392.9 64 451.5 64 512c0 47.2 7.3 93.8 21.8 138.3 4.4 13.5 16.9 22.1 30.4 22.1 3.3 0 6.6-0.5 9.9-1.6 16.8-5.5 26-23.5 20.6-40.3-12.4-38.1-18.6-78-18.6-118.5 0-203.7 159.5-370.9 360.1-383.3a446.34 446.34 0 0 0-104.1-46.2c-15.7 4.7-31.2 10.2-46.4 16.7-53.4 22.6-101.4 54.9-142.5 96zM441.6 423.8l-237.8 238c-43.7 43.7-43.7 114.7 0 158.4s114.7 43.7 158.4 0l237.9-237.9 92.4 30.9C700 580.7 704 546.8 704 512c0-18.6-1.1-36.9-3.3-54.8l-100.3-33.6-39.7-118.7 57.1-57.1c-22.1-30.3-48-57.7-76.9-81.5L402 305.2l39.6 118.6zM283 701.4c10.9-10.9 28.7-10.9 39.6 0 10.9 10.9 10.9 28.7 0 39.6L283 780.6c-10.9 10.9-28.7 10.9-39.6 0-10.9-10.9-10.9-28.7 0-39.6" fill="#3D5AFE"></path></g></svg>
							<span>Package</span>
							<span>Inactive</span>
						</div>
					</li>
						<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
								<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M242.3 743.4h603.4c27.8 0 50.3-22.5 50.3-50.3V192H192v501.1c0 27.8 22.5 50.3 50.3 50.3z" fill="#FFEA00"></path><path d="M178.3 807.4h603.4c27.8 0 50.3-22.5 50.3-50.3V256H128v501.1c0 27.8 22.5 50.3 50.3 50.3z" fill="#FFFF8D"></path><path d="M960 515v384c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V383.8c0-35.3 28.7-64 64-64h344.1c24.5 0 46.8 13.9 57.5 35.9l46.5 95.3H896c35.3 0 64 28.7 64 64z" fill="#3D5AFE"></path><path d="M704 512c0-20.7-1.4-41.1-4.1-61H576.1l-46.5-95.3c-10.7-22-33.1-35.9-57.5-35.9H128c-35.3 0-64 28.7-64 64V899c0 6.7 1 13.2 3 19.3C124.4 945 188.5 960 256 960c247.4 0 448-200.6 448-448z" fill="#536DFE"></path></g></svg>
						
							<span>Cashback</span>
							<span>KES50640</span>
						</div>
					</li>
						<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
							<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M512 192m-128 0a128 128 0 1 0 256 0 128 128 0 1 0-256 0Z" fill="#FFEA00"></path><path d="M110.021808 743.473457a128 128 0 1 0 221.702503-128 128 128 0 1 0-221.702503 128Z" fill="#FFEA00"></path><path d="M739.582127 791.504295a128 128 0 1 0 128-221.702504 128 128 0 1 0-128 221.702504Z" fill="#FFEA00"></path><path d="M181.7 509.3c-4.2 0-8.4-0.4-12.7-1.3-34.7-7-57.1-40.7-50.2-75.3 9.1-45.2 25.4-87.6 48.6-125.8 22.9-37.7 51.9-70.7 86.3-98.1 34.3-27.3 73.2-48.5 115.6-62.9C412.2 131.4 457.8 124 505 124c35.3 0 64 28.7 64 64s-28.7 64-64 64c-133.2 0-235.5 80.8-260.7 205.9-6.1 30.4-32.8 51.4-62.6 51.4zM512 913c-71.5 0-140.8-18.3-200.5-53.1-58.2-33.8-107.2-83.2-141.9-142.8-17.8-30.6-7.4-69.7 23.1-87.5 30.6-17.8 69.7-7.4 87.5 23.1C329.2 736.8 413.6 785 512 785c27.7 0 54.9-4.1 81-12.2 33.8-10.5 69.6 8.4 80.1 42.2 10.5 33.8-8.4 69.6-42.2 80.1C592.5 907 552.5 913 512 913zM807.9 738c-10.9 0-21.9-2.8-32-8.6-30.6-17.7-41-56.9-23.3-87.5C775 603.3 785 563.2 785 512c0-72.9-28.4-141.5-80-193-25-25-25-65.5 0-90.5s65.5-25 90.5 0c36.8 36.8 65.7 79.7 85.9 127.4 20.9 49.5 31.5 102 31.5 156.1 0 74-15.8 135.7-49.6 194.1-11.8 20.5-33.3 31.9-55.4 31.9z" fill="#3D5AFE"></path></g></svg>
							<span>UserSpin</span>
							<span>KES50640</span>
						</div>
					</li>
						<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
							<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M896 64H128c-35.3 0-64 28.7-64 64v544c0 17.7 14.3 32 32 32h671.6v224c0 17.7 14.3 32 32 32s32-14.3 32-32V704H928c17.7 0 32-14.3 32-32V128c0-35.3-28.7-64-64-64z" fill="#3D5AFE"></path><path d="M704 512c0-247.4-200.6-448-448-448H128c-27.3 0-50.6 17.1-59.8 41.1-2.7 7.1-4.2 14.8-4.2 22.9v544c0 17.7 14.3 32 32 32h95.6v224c0 17.7 14.3 32 32 32s32-14.3 32-32V704h405.3c27.6-58.2 43.1-123.3 43.1-192z" fill="#536DFE"></path><path d="M453.9 475.8l-0.6 0.6 0.6-0.6zM456.4 472.9c-0.4 0.4-0.8 0.9-1.1 1.3 0.3-0.4 0.7-0.8 1.1-1.3zM478.4 437.4c0.4-1 0.8-1.9 1.2-2.9-0.4 1-0.8 1.9-1.2 2.9zM489.1 385.9c0 2.2-0.1 4.4-0.2 6.6 0.1-2.1 0.2-4.3 0.2-6.6zM484.5 419.6c0.7-2.7 1.4-5.4 1.9-8.1-0.6 2.7-1.2 5.4-1.9 8.1z" fill="#FFEA00"></path><path d="M511 366.4l-22.7 2.5c0.5 4.4 0.8 8.8 0.8 13.2V385.9c-0.2 17.9-3.9 35.1-10.8 51.5-0.1 0.2-0.1 0.3-0.2 0.5 0.1-0.1 0.1-0.3 0.2-0.4-0.1 0.3-0.3 0.6-0.4 0.9 0.1-0.2 0.1-0.3 0.2-0.5-0.1 0.1-0.1 0.3-0.2 0.5-0.2 0.4-0.4 0.8-0.5 1.2-0.3 0.6-0.6 1.3-0.9 2-0.1 0.3-0.3 0.6-0.4 0.9-0.4 0.8-0.8 1.6-1.1 2.4-0.1 0.1-0.1 0.3-0.2 0.4-4.4 8.8-9.7 17.1-15.9 24.8l-0.1 0.1c-0.2 0.3-0.5 0.6-0.7 0.9-0.1 0.1-0.2 0.2-0.2 0.3-0.2 0.3-0.5 0.6-0.7 0.8-0.3 0.3-0.5 0.6-0.7 0.9-0.4 0.4-0.8 0.9-1.1 1.3-0.4 0.5-0.9 1-1.4 1.5l-0.6 0.6c-0.6 0.7-1.3 1.4-1.9 2l-0.2 0.2c-1.5 1.6-3 3.1-4.6 4.6l-0.2 0.2c-0.7 0.6-1.4 1.3-2 1.9l-0.6 0.6c-0.5 0.5-1 0.9-1.5 1.4-0.4 0.4-0.9 0.7-1.3 1.1-0.3 0.3-0.6 0.5-0.9 0.7-0.7 0.6-1.4 1.1-2 1.7l-0.1 0.1c-7.7 6.2-16 11.5-24.7 15.9-0.1 0.1-0.3 0.1-0.4 0.2-0.8 0.4-1.6 0.8-2.4 1.1-0.3 0.1-0.6 0.3-0.9 0.4-0.6 0.3-1.3 0.6-2 0.9-0.4 0.2-0.8 0.4-1.2 0.5-0.3 0.1-0.6 0.3-0.9 0.4-16.3 6.9-33.6 10.5-51.5 10.7H350.3c-17.9-0.3-35.1-3.9-51.5-10.7-0.3-0.1-0.6-0.3-0.9-0.4-0.4-0.2-0.8-0.4-1.2-0.5-0.6-0.3-1.3-0.6-2-0.9-0.3-0.1-0.6-0.3-0.9-0.4-0.8-0.4-1.6-0.8-2.4-1.1-0.1-0.1-0.3-0.1-0.4-0.2-8.8-4.4-17.1-9.7-24.7-15.9l-0.1-0.1c-0.7-0.5-1.4-1.1-2-1.7-0.3-0.3-0.6-0.5-0.9-0.7-0.4-0.4-0.9-0.8-1.3-1.1-0.5-0.4-1-0.9-1.5-1.4l-0.6-0.6c-0.2-0.2-0.5-0.4-0.7-0.6 0.2 0.2 0.4 0.4 0.6 0.5l0.6 0.6c0.5 0.5 1 0.9 1.5 1.4 0.4 0.4 0.9 0.7 1.3 1.1 0.3 0.3 0.6 0.5 0.9 0.7 0.7 0.6 1.4 1.1 2 1.7l0.1 0.1c7.6 6.1 15.9 11.5 24.7 15.9 0.1 0.1 0.3 0.1 0.4 0.2 0.8 0.4 1.6 0.8 2.4 1.1 0.3 0.1 0.6 0.3 0.9 0.4 0.6 0.3 1.3 0.6 2 0.9 0.4 0.2 0.8 0.4 1.2 0.5 16.1 7 33.8 10.9 52.4 11.1H354c18.6-0.3 36.3-4.2 52.4-11.1 0.4-0.2 0.8-0.4 1.2-0.5 0.6-0.3 1.3-0.6 2-0.9 0.3-0.1 0.6-0.3 0.9-0.4 0.8-0.4 1.6-0.8 2.4-1.1 0.1-0.1 0.3-0.1 0.4-0.2 8.9-4.4 17.1-9.8 24.7-15.9l0.1-0.1c0.7-0.5 1.4-1.1 2-1.7 0.3-0.3 0.6-0.5 0.9-0.7 0.4-0.4 0.9-0.8 1.3-1.1 0.5-0.4 1-0.9 1.5-1.4l0.6-0.6c0.7-0.6 1.4-1.3 2-1.9l0.2-0.2c0.8-0.8 1.6-1.5 2.3-2.3 0.7-0.8 1.5-1.5 2.3-2.3l0.2-0.2c0.6-0.7 1.3-1.4 1.9-2l0.6-0.6c0.5-0.5 0.9-1 1.4-1.5 0.4-0.4 0.8-0.9 1.1-1.3 0.3-0.3 0.5-0.6 0.7-0.9 0.6-0.7 1.1-1.4 1.7-2l0.1-0.1c6.1-7.6 11.5-15.9 15.9-24.8 0.1-0.1 0.1-0.3 0.2-0.4 0.4-0.8 0.8-1.6 1.1-2.4 0.1-0.3 0.3-0.6 0.4-0.9 0.3-0.6 0.6-1.3 0.9-2 0.2-0.4 0.4-0.8 0.5-1.2 7-16.1 10.9-33.8 11.1-52.4v-0.1-1.8V382.1c-0.1-4.5-0.3-8.9-0.8-13.2l-68.1 7.7c0.3 2.5 0.4 5 0.4 7.5 0 37.8-30.7 68.5-68.5 68.5s-68.5-30.7-68.5-68.5 30.7-68.5 68.5-68.5c2.6 0 5.1 0.1 7.6 0.4l7.6-68.2h0.1l2.5-22.7c-5.9-0.7-11.8-1.1-17.8-1.1-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160c0-6-0.3-11.9-1-17.6zM254.6 480.3l0.5 0.5 2.3 2.3 0.1 0.1-2.9-2.9z m3.1 3.1l-0.1-0.1c0.2 0.2 0.4 0.4 0.6 0.5-0.2-0.2-0.3-0.3-0.5-0.4z" fill="#FFEA00"></path><path d="M478 438.3c-0.2 0.4-0.4 0.8-0.5 1.2 0.1-0.4 0.3-0.8 0.5-1.2zM405 257.5c0.4 0.2 0.8 0.3 1.2 0.5-0.3-0.1-0.6-0.3-0.9-0.4 0 0-0.2 0-0.3-0.1zM405 257.5c-7.4-3.1-15.2-5.6-23.3-7.4 8 1.8 15.8 4.2 23.3 7.4z" fill="#FFEA00"></path><path d="M409.4 259.5c0.3 0.1 0.6 0.3 0.9 0.4 0.8 0.4 1.6 0.8 2.4 1.1 0.1 0.1 0.3 0.1 0.4 0.2 8.8 4.4 17.1 9.7 24.8 15.9l0.1 0.1c0.7 0.5 1.4 1.1 2 1.7 0.2 0.1 0.3 0.3 0.5 0.4-0.1-0.1-0.3-0.2-0.4-0.3-0.7-0.6-1.4-1.1-2-1.7l-0.1-0.1c-7.6-6.1-15.9-11.5-24.8-15.9-0.1-0.1-0.3-0.1-0.4-0.2-0.8-0.4-1.6-0.8-2.4-1.1-0.3-0.2-0.6-0.3-1-0.5-0.6-0.2-1.3-0.5-1.9-0.8-0.4-0.2-0.8-0.4-1.2-0.5-7.8-3.4-16-6.1-24.6-7.9l-14.9 67c25.9 5.7 46.3 26.1 52 52l67-14.9v-0.2l22.2-5c-13.4-60.4-61-108-121.5-121.4l-4.9 22.3c8.1 1.8 16 4.3 23.6 7.5 0.3 0.1 0.6 0.3 0.9 0.4 0.4 0.2 0.8 0.4 1.2 0.5 0.8 0.4 1.5 0.7 2.1 1z m42 30l-0.1-0.1c0 0.1 0 0.1 0.1 0.1z m-5-4.9l0.2 0.2c1 0.9 2 1.9 2.9 2.9-0.2-0.2-0.3-0.4-0.5-0.5l-2.3-2.3-0.3-0.3c-0.1 0-0.2-0.2-0.3-0.3l0.3 0.3z m-2.7-2.5l0.6 0.6c0.2 0.1 0.3 0.3 0.5 0.4-0.1-0.1-0.3-0.2-0.4-0.4-0.2-0.2-0.4-0.3-0.7-0.6l-0.5-0.5 0.5 0.5z m-2.8-2.5c0.4 0.4 0.9 0.8 1.3 1.1 0.2 0.2 0.5 0.4 0.7 0.6l-0.6-0.6c-0.5-0.3-0.9-0.7-1.4-1.1-0.1 0-0.2-0.2-0.3-0.3l0.3 0.3z" fill="#FFFF8D"></path><path d="M672 288.3h128c17.7 0 32 14.3 32 32s-14.3 32-32 32H672c-17.7 0-32-14.3-32-32s14.3-32 32-32zM672 415.7h128c17.7 0 32 14.3 32 32s-14.3 32-32 32H672c-17.7 0-32-14.3-32-32s14.3-32 32-32z" fill="#FFEA00"></path></g></svg>
							<span>DailyPledge</span>
							<span>KES5000</span>
						</div>
					</li>
						<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
						<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M128 928h768c35.3 0 64-28.7 64-64V226.2H64V864c0 35.3 28.7 64 64 64zM64 162.2v64h896v-64c0-35.3-28.7-64-64-64H128c-35.3 0-64 28.7-64 64z m96 29.8c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z m128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z" fill="#3D5AFE"></path><path d="M160 160m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#FFEA00"></path><path d="M288 160m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#FFEA00"></path><path d="M864.2 449H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h702.2c17.7 0 32 14.3 32 32s-14.4 32-32 32zM800.2 832H166c-17.7 0-32-14.3-32-32s14.3-32 32-32h634.2c17.7 0 32 14.3 32 32s-14.4 32-32 32zM416.1 573H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h254.1c17.7 0 32 14.3 32 32s-14.3 32-32 32z" fill="#FFEA00"></path><path d="M350.1 544H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h254.1c17.7 0 32 14.3 32 32s-14.3 32-32 32z" fill="#FFEA00"></path><path d="M224 832.1c-17.7 0-32-14.3-32-32s14.3-32 32-32h398.9C674 695.3 704 606.6 704 510.9c0-21.4-1.5-42.4-4.4-63H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h523.7C668.4 325 639.2 271.2 601 225.1H64v637.8c0 35.3 28.7 64 64 64h294.6c54.7-21.9 104.2-54.4 145.7-94.8H224z" fill="#448AFF"></path><path d="M192 800.1c0 17.7 14.3 32 32 32h344.3c20.1-19.6 38.4-41 54.5-64H224c-17.7 0-32 14.3-32 32z" fill="#FFFF00"></path><path d="M64 161.1v64h537c-46.1-55.6-105.4-99.8-173-128H128c-35.3 0-64 28.7-64 64z m224-34.2c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.4-32 32-32z m-128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.4-32 32-32z" fill="#536DFE"></path><path d="M130 415.9c0 17.7 14.3 32 32 32h537.6c-3.1-21.9-7.7-43.3-13.9-64H162c-17.7 0-32 14.3-32 32z" fill="#FFFF00"></path></g></svg>
							<span>MyIncome</span>
							<span>KES506040</span>
						</div>
					</li>
						<li class="category-item col-3">
						<div style="height:80px;width:70px;border-radius:10px;background-color:#1CE3C8">
						<svg viewBox="0 0 1024 1024" height="30" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M128 928h768c35.3 0 64-28.7 64-64V226.2H64V864c0 35.3 28.7 64 64 64zM64 162.2v64h896v-64c0-35.3-28.7-64-64-64H128c-35.3 0-64 28.7-64 64z m96 29.8c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z m128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z" fill="#3D5AFE"></path><path d="M160 160m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#FFEA00"></path><path d="M288 160m-32 0a32 32 0 1 0 64 0 32 32 0 1 0-64 0Z" fill="#FFEA00"></path><path d="M864.2 449H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h702.2c17.7 0 32 14.3 32 32s-14.4 32-32 32zM800.2 832H166c-17.7 0-32-14.3-32-32s14.3-32 32-32h634.2c17.7 0 32 14.3 32 32s-14.4 32-32 32zM416.1 573H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h254.1c17.7 0 32 14.3 32 32s-14.3 32-32 32z" fill="#FFEA00"></path><path d="M350.1 544H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h254.1c17.7 0 32 14.3 32 32s-14.3 32-32 32z" fill="#FFEA00"></path><path d="M224 832.1c-17.7 0-32-14.3-32-32s14.3-32 32-32h398.9C674 695.3 704 606.6 704 510.9c0-21.4-1.5-42.4-4.4-63H162c-17.7 0-32-14.3-32-32s14.3-32 32-32h523.7C668.4 325 639.2 271.2 601 225.1H64v637.8c0 35.3 28.7 64 64 64h294.6c54.7-21.9 104.2-54.4 145.7-94.8H224z" fill="#448AFF"></path><path d="M192 800.1c0 17.7 14.3 32 32 32h344.3c20.1-19.6 38.4-41 54.5-64H224c-17.7 0-32 14.3-32 32z" fill="#FFFF00"></path><path d="M64 161.1v64h537c-46.1-55.6-105.4-99.8-173-128H128c-35.3 0-64 28.7-64 64z m224-34.2c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.4-32 32-32z m-128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.4-32 32-32z" fill="#536DFE"></path><path d="M130 415.9c0 17.7 14.3 32 32 32h537.6c-3.1-21.9-7.7-43.3-13.9-64H162c-17.7 0-32 14.3-32 32z" fill="#FFFF00"></path></g></svg>
							<span>MyTeam</span>
							<span>20</span>
						</div>
					</li>
					
				
				</ul>
			</div>
			<!-- Catagory End -->
			
			<!-- ComingSoon start -->
			<div class="dz-coming-soon" style="background-image: url('assets/images/background/bg2.png'); background-position: center; background-size: cover;">
				<div class="media media-55 me-5">
					<img src="assets/images/offer/pic1.png" alt="">	
				</div>
				<div class="offer-content">
					<span class="text-white">Sales end in</span>
					<div class="countdown-timer">
						<div class="countdown">
							<div class="date">
								<span class="time" id="hour">00</span>
								<span class="text">hrs</span>
							</div>
							<div class="date">
								<span class="time" id="min">00</span>
								<span class="text">Mins</span>
							</div>
							<div class="date">
								<div class="time lost" id="second">00</div>
								<span class="text">Secs</span>
							</div>
						</div>
					</div>
				</div>	
			</div>	
			<!-- ComingSoon End -->
			
			<div class="title-bar">
				<h6 class="title mb-0">Most Popular</h6>
				<a href="product.html">View all <i class="icon feather icon-chevron-right"></i></a>
			</div>
			
			<!-- Shop Section Strat -->
			<div class="swiper product-swiper">
				<div class="swiper-wrapper">
					<div class="swiper-slide">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product-detail.html">
									<img src="assets/images/product/pic1.jpg" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title font-12"><a href="product-detail.html">Peter England cassual</a></h6>
								<h6 class="price">$45.00<del>$50.15</del></h6>
							</div>
						</div>
					</div>
					<div class="swiper-slide">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product-detail.html">
									<img src="assets/images/product/pic2.jpg" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title title font-12"><a href="product-detail.html">Zip-Front Track Jacket</a></h6>
								<h6 class="price">$23.12<del>$30.15</del></h6>
							</div>
						</div>
					</div>
					<div class="swiper-slide">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product-detail.html">
									<img src="assets/images/product/pic3.jpg" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title font-12"><a href="product-detail.html">Louis Vuitton Jacket..</a></h6>
								<h6 class="price">$155.30<del>$200.12</del></h6>
							</div>
						</div>
					</div>
					<div class="swiper-slide">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product-detail.html">
									<img src="assets/images/product/pic4.jpg" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title font-12 "><a href="product-detail.html">Zip-Front Track Jacket</a></h6>
								<h6 class="price">$250.00<del>$300.25</del></h6>
							</div>
						</div>
					</div>
					<div class="swiper-slide">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product-detail.html">
									<img src="assets/images/product/pic5.jpg" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title font-12"><a href="product-detail.html">Peter England cassual</a></h6>
								<h6 class="price">$25.15<del>$30.15</del></h6>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- Shop Section End -->
			
			<!-- Product offer Start -->
			<div class="product-offer">
				<div class="row g-3">
					<div class="col-4">
						<a href="product-detail.html">
							<div class="shop-card style-3">
								<div class="dz-media">
									<img src="assets/images/product/pic9.png" alt="image">	
								</div>
								<div class="dz-content">
									<span class="offer">Headphones</span>
									<h6 class="title">Up to 80% off</h6>
								</div>
							</div>
						</a>
					</div>
					<div class="col-4">
						<a href="product-detail.html">
							<div class="shop-card style-3">
								<div class="dz-media">
									<img src="assets/images/product/pic10.png" alt="image">	
								</div>
								<div class="dz-content">
									<span class="offer">Mobile Phones</span>
									<h6 class="title">From $1999</h6>
								</div>
							</div>
						</a>
					</div>
					<div class="col-4">
						<a href="product-detail.html">
							<div class="shop-card style-3">
								<div class="dz-media">
									<img src="assets/images/product/pic11.png" alt="image">	
								</div>
								<div class="dz-content">
									<span class="offer">Laptops</span>
									<h6 class="title">Up to 50% off</h6>
								</div>
							</div>
						</a>	
					</div>
				</div>	
			</div>	
			<!-- Product offer End -->
			
			<div class="title-bar">
				<h6 class="title mb-0">Popular Items</h6>
				<a href="product.html">View all <i class="icon feather icon-chevron-right"></i></a>
			</div>
			
			<!-- Product Item list Start -->
			<div class="product-items-list">
				<ul>
					<li>
						<div class="product-items">
							<a href="cart.html">
								<div class="media media-80 me-2">
									<img src="assets/images/product/pic12.png" alt="">
								</div>
							</a>
							<a href="cart.html">	
								<div class="product-content">
									<h6 class="title">Havells Swing Fan</h6>
									<div class="desc">400mm , Blue tone</div>
									<div class="product-footer">
										<span class="offer">20% off</span>
										<span class="price">
											<del>$1500</del>
											$1,299
										</span>
									</div>
								</div>
							</a>
							<a href="cart.html" class="dz-icon"><i class="icon feather icon-shopping-cart"></i></a>
						</div>
					</li>
					<li>
						<div class="product-items">
							<a href="cart.html">
								<div class="media media-80 me-2">
									<img src="assets/images/product/pic13.png" alt="">
								</div>
							</a>
							<a href="cart.html">
								<div class="product-content">
									<h6 class="title">OnePlus Nord 2T 5G</h6>
									<div class="desc">8GB RAM, 128GB Storage</div>
									<div class="product-footer">
										<span class="offer">50% off</span>
										<span class="price">
											<del>$1,500</del>
											$999
										</span>
									</div>
								</div>
							</a>
							<a href="cart.html" class="dz-icon"><i class="icon feather icon-shopping-cart"></i></a>
						</div>
					</li>
					<li>
						<div class="product-items">
							<a href="cart.html">	
								<div class="media media-80 me-2">
									<img src="assets/images/product/pic14.png" alt="">
								</div>
							</a>
							<a href="cart.html">	
								<div class="product-content">
									<h6 class="title">ThinkPad L13 Yoga Gen 3</h6>
									<div class="desc">Dual core , Red tone</div>
									<div class="product-footer">
										<span class="offer">20% off</span>
										<span class="price">
											<del>$2500</del>
											$2299
										</span>
									</div>
								</div>
							</a>
							<a href="cart.html" class="dz-icon"><i class="icon feather icon-shopping-cart"></i></a>
						</div>
					</li>
				</ul>
			</div>
			<!-- Product Item list End -->
			
			<!-- Top Selection Start -->
			<div class="top-selection">
				<div class="title-bar mt-0">
					<h6 class="title text-white">Top Seleciton</h6>
				</div>
				<div class="row g-3">
					<div class="col-6">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product.html">
									<img src="assets/images/product/pic15.png" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title"><a href="product.html">Wired Earphones</a></h6>
								<span class="offer">upto 50% off</span>
							</div>
						</div>
					</div>
					<div class="col-6">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product.html">
									<img src="assets/images/product/pic10.png" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title"><a href="product.html">Top Mobiles</a></h6>
								<span class="offer">upto 50% off</span>
							</div>
						</div>
					</div>
					<div class="col-6">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product.html">
									<img src="assets/images/product/pic9.png" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title"><a href="product.html">Headphones</a></h6>
								<span class="offer">upto 50% off</span>
							</div>
						</div>
					</div>
					<div class="col-6">
						<div class="shop-card">
							<div class="dz-media">
								<a href="product.html">
									<img src="assets/images/product/pic11.png" alt="image">	
								</a>
							</div>
							<div class="dz-content">
								<h6 class="title"><a href="product.html">Best Laptops</a></h6>
								<span class="offer">upto 50% off</span>
							</div>
						</div>
					</div>
				</div>	
			</div>	
			<!-- Top Selection End -->
		</div>
	</div>
	<!-- Page Content End -->
	
	<!-- Menubar -->
	<div class="menubar-area footer-fixed rounded-0 border-top">
		<div class="toolbar-inner menubar-nav">
			<a href="index.html" class="nav-link active">
				<i class="icon feather icon-home"></i>
				<span>Home</span>
			</a>
			<a href="category.html" class="nav-link">
				<i class="icon feather icon-grid"></i>
				<span>Categories</span>
			</a>
			<a href="wishlist.html" class="nav-link">
				<i class="icon feather icon-heart"></i>
				<span>Wishlist</span>
			</a>
			<a href="profile.html" class="nav-link">
				<i class="icon feather icon-user"></i>
				<span>Profile</span>
			</a>
		</div>
	</div>
	<!-- Menubar -->
	<!-- PWA Offcanvas -->
	<div class="offcanvas offcanvas-bottom pwa-offcanvas">
		<div class="container">
			<div class="offcanvas-body small">
				<img class="logo dark" src="assets/images/logo.png" alt="">
				<img class="logo light" src="assets/images/logo-white.png" alt="">
				<h5 class="title">Wedo - Ecommerce Mobile App Template ( Bootstrap + PWA )</h5>
				<p class="pwa-text">Install "Wedo Ecommerce Mobile App" template to your home screen for easy access, just like any other app</p>
				<button type="button" class="btn btn-sm btn-primary pwa-btn">Add to Home Screen</button>
				<button type="button" class="btn btn-sm pwa-close btn-secondary ms-2 text-white">Maybe later</button>
			</div>
		</div>
	</div>
	<div class="offcanvas-backdrop pwa-backdrop"></div>
	<!-- PWA Offcanvas End --> 
	
	
	<!-- Multicolor Canvas Start --> 
	<div class="offcanvas offcanvas-bottom m-3 rounded" tabindex="-1" id="offcanvasBottom" aria-labelledby="offcanvasBottomLabel">
		<div class="offcanvas-body small">
			<ul class="theme-color-settings">
				<li>
					<input class="filled-in" id="primary_color_1" name="theme_color" type="radio" value="color-primary">
					<label for="primary_color_1"></label>
					<span>Default</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_2" name="theme_color" type="radio" value="color-green">
					<label for="primary_color_2"></label>
					<span>Green</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_3" name="theme_color" type="radio" value="color-blue">
					<label for="primary_color_3"></label>
					<span>Blue</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_4" name="theme_color" type="radio" value="color-pink">
					<label for="primary_color_4"></label>
					<span>Pink</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_5" name="theme_color" type="radio" value="color-yellow">
					<label for="primary_color_5"></label>
					<span>Yellow</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_6" name="theme_color" type="radio" value="color-orange">
					<label for="primary_color_6"></label>
					<span>Orange</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_7" name="theme_color" type="radio" value="color-purple">
					<label for="primary_color_7"></label>
					<span>Purple</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_8" name="theme_color" type="radio" value="color-red">
					<label for="primary_color_8"></label>
					<span>Red</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_9" name="theme_color" type="radio" value="color-lightblue">
					<label for="primary_color_9"></label>
					<span>Lightblue</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_10" name="theme_color" type="radio" value="color-teal">
					<label for="primary_color_10"></label>
					<span>Teal</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_11" name="theme_color" type="radio" value="color-lime">
					<label for="primary_color_11"></label>
					<span>Lime</span>
				</li>
				<li>
					<input class="filled-in" id="primary_color_12" name="theme_color" type="radio" value="color-deeporange">
					<label for="primary_color_12"></label>
					<span>Deeporange</span>
				</li>
			</ul>
		</div>
	</div>
	<!-- Multicolor Canvas Start --> 
	
</div>  
<!--**********************************
    Scripts
***********************************-->
<script src="assets/js/jquery.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script><!-- Swiper -->
<script src="assets/vendor/countdown/jquery.countdown.js"></script><!-- COUNTDOWN FUCTIONS  -->
<script src="assets/vendor/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js"></script><!-- Swiper -->
<script src="assets/js/dz.carousel.js"></script><!-- Swiper -->
<script src="assets/js/settings.js"></script>
<script src="assets/js/custom.js"></script>
<script src="index.js"></script>
</body>
</html><?php /**PATH /home/perfectm/bluebird.topgainagencies.com/resources/views/home.blade.php ENDPATH**/ ?>