<?php

namespace App\Http\Controllers\Auth;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\Referrals;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255','unique:users'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            
            
            'password' => ['required', 'string', 'min:8'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
       
            
 $mobile=$data['mobile'];
        $first_digit = $mobile[0];
  
  if($first_digit == 0){
      $mobile1 = '254'.substr($mobile,1);
  }
       if($first_digit == 7){
      $mobile1 = '254'.$mobile;
  }
       if($first_digit == "+"){
      $mobile1 = substr($mobile,1);
  }
       if($first_digit == 1){
      $mobile1 = '254'.$mobile;
  }
  
  if($first_digit == '2'){
      $mobile1 = $mobile;
  }

       $done= User::create([
            'name' => preg_replace('/\s+/', '',$data['name']),
            'email' => $data['email'],
            'mobile' => $mobile1 ,
            'package' => 0 ,
            'country' =>'Kenya',
            'balance' =>0.00,
            'invest_status' =>0,
            
           
             
            
            'password' => Hash::make($data['password']),
            'referral_token' =>  1,
            'ref_id' =>  1,
            'tauth' =>   0,
            'tfver' =>   0,
            'secretcode' =>   0,
            'status' =>0,
        ]);
        
        if($done)
        
        {
           
         $email=$data['email'];
        $name=$data['name'];
      
        return $done;
	 
        }
        
        
       
        
        
    }
    public function showRegistrationForm($referral_token = null)
    {
        if($referral_token){
            $data['refName'] = User::where('referral_token',$referral_token)->first();
        }
        $data['page_title'] = "Sign-up";
        return view('auth.register',$data);
    }
}
