<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Lib\GoogleAuthenticator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Models\admindvalues;
use App\Models\HotspotUsers;
use App\Models\systemSetting;


use App\Models\UploadTask;
use App\Http\Controllers\DetailsController;
use App\Models\Services;
use App\Models\withdraw_logs;
use App\Models\User;
use App\Models\Transactions;
use App\Models\Routers;
use App\Models\Packages;
use App\Models\MpesaTransaction;
use Illuminate\Support\Facades\Http;
use App\Models\Pppoeusers;
use App\Models\PppoePackages;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        
        // $t=User::where('isadmin',0)->count();
        // for($x=0; $x < $t; $x++)
  // $users=User::where('isadmin',0)->get();
  //  foreach($users as $user)
  //  {
  //       $mob=$user->mobile;
 // $user->password=Hash::make($mob);
 //  $user->update();
        
   // }
  //  $query="SELECT * FROM sharematurity where username='$username' and paid ='0'";


    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
     
     
     //help functon
     public static function getservicetitle($id)
     {
         try{
              $data=Services::findorFail($id);
              
              return $data->service_title;
         
     }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
     }
     
     
    public function dashboard()
    {
        $me=\Auth::user();

         // $data['systemusers']=User::count();
          $data['connections']= HotspotUsers::count();
      
          $data['activeconnections']= HotspotUsers::where('user_status',1)->count();
          $data['inactiveconnections']= HotspotUsers::where('user_status',0)->count();
      
        
          $data['payments']= MpesaTransaction::sum('TransAmount');
      $data['mpesadata']= MpesaTransaction::limit(5)->get();
      $data['dailypayments']= MpesaTransaction::whereDate('created_at', date('Y-m-d'))->sum('TransAmount');
          $data['users']=HotspotUsers::query()
        ->selectRaw("DATE_FORMAT(created_at, '%Y-%m') as month, COUNT(*) as user_count")
        ->groupBy('month')
        ->orderBy('month')
        ->get();
      
      
      $data['userStats'] = HotspotUsers::query()
        ->selectRaw("CASE WHEN user_status = 1 THEN 'Active' ELSE 'Inactive' END as status, COUNT(*) as count")
        ->groupBy('status')
        ->get();
          
        return view('user.dashboard',$data);
        
        
        
    }


  
   public function initiatePayment(Request $request)
    {
        $phoneNumber = $request->phone;
        $amount = 10; // Example amount

        // Simulated API request to payment provider
       
        
            // Save the transaction in the database
           

            return response()->json(['status' => 'pending', 'transaction_id' => $phoneNumber]);
       
    }

  public function paymentCallback(Request $request)
{
    $transactionId = $request->transaction_id;
    $status = $request->status; // Example: 'success' or 'failed'

    // Find the payment record
   

        return response()->json(['message' => 'Payment updated']);
  
}



   public function pppoeanalytics()
    {
        $me=\Auth::user();

              $data['connections']= Pppoeusers::count();
      
          $data['activeconnections']= Pppoeusers::where('status',1)->count();
          $data['inactiveconnections']= Pppoeusers::where('status',0)->count();
      
        
          $data['payments']= MpesaTransaction::where('TransAmount','>',500)->sum('TransAmount');
      $data['mpesadata']= MpesaTransaction::where('TransAmount','>',500)->limit(5)->get();
      $data['dailypayments']= MpesaTransaction::where('TransAmount','>',500)->whereDate('created_at', date('Y-m-d'))->sum('TransAmount');
          $data['users']=Pppoeusers::query()
        ->selectRaw("DATE_FORMAT(created_at, '%Y-%m') as month, COUNT(*) as user_count")
        ->groupBy('month')
        ->orderBy('month')
        ->get();
      
      
      $data['userStats'] = HotspotUsers::query()
        ->selectRaw("CASE WHEN user_status = 1 THEN 'Active' ELSE 'Inactive' END as status, COUNT(*) as count")
        ->groupBy('status')
        ->get(); 
          
        return view('user.pppoeanalytics',$data);
        
        
        
    }
  
  
  public function pppoeanalyticsuserStats()
{
    $activeUsers = Pppoeusers::where('status', 1)->count();  // Count active users
    $inactiveUsers = Pppoeusers::where('status', 0)->count();  // Count inactive users

    return response()->json([
        'active' => $activeUsers,
        'inactive' => $inactiveUsers,
    ]);
}

     public function hotspotanalytics()
    {
        $me=\Auth::user();

               $data['connections']= HotspotUsers::count();
      
          $data['activeconnections']= HotspotUsers::where('user_status',1)->count();
          $data['inactiveconnections']= HotspotUsers::where('user_status',0)->count();
      
        
          $data['payments']= MpesaTransaction::where('TransAmount','<',500)->sum('TransAmount');
      $data['mpesadata']= MpesaTransaction::where('TransAmount','<',500)->limit(5)->get();
      $data['dailypayments']= MpesaTransaction::where('TransAmount','<',500)->whereDate('created_at', date('Y-m-d'))->sum('TransAmount');
          $data['users']=HotspotUsers::query()
        ->selectRaw("DATE_FORMAT(created_at, '%Y-%m') as month, COUNT(*) as user_count")
        ->groupBy('month')
        ->orderBy('month')
        ->get();
      
      
      $data['userStats'] = HotspotUsers::query()
        ->selectRaw("CASE WHEN user_status = 1 THEN 'Active' ELSE 'Inactive' END as status, COUNT(*) as count")
        ->groupBy('status')
        ->get();
          
        return view('user.hotspotanalytics',$data);
        
        
        
    }
  
  public function hotspotanalyticsuserStats()
{
    // Get count of active and inactive users
    $activeUsers = HotspotUsers::where('user_status',1)->count();
    $inactiveUsers = HotspotUsers::where('user_status',0)->count();

    return response()->json([
        'labels' => ['Active Users', 'Inactive Users'],
        'data' => [$activeUsers, $inactiveUsers]
    ]);
}
  
   public function createppoepayment()
    {
       
       $data['packages']=Pppoeusers::get();
   
        return view('user.createppoepayment',$data);
        
        
        
    }
  
  
  
  
   public function createppoepaymentpost(Request $request)
    {
        $me=\Auth::user();
     $transactioncode=$request->transactioncode;
     $name=$request->username;
      $amount=$request->amount;
    
     $mobile=$request->mobile;
     $time=time()+(3600*24*30);
     
     if(!$Existpppoeuser=Pppoeusers::where('username',$name)->exists())
     {
    return response()->json(['message' => 'Failed ,User Does not exist ,please check and try again'], 200);
     }
     else{
    
       
        
        $first_digit = $mobile[0];
  
  if($first_digit == 0){
      $mobile1 = '254'.substr($mobile,1);
  }
       if($first_digit == 7){
      $mobile1 = '254'.$mobile;
  }
       if($first_digit == "+"){
      $mobile1 = substr($mobile,1);
  }
       if($first_digit == 1){
      $mobile1 = '254'.$mobile;
  }
  
  if($first_digit == '2'){
      $mobile1 = $mobile;
  } 
       
        $storedata=MpesaTransaction::create(
     [
     'MSISDN'=>$mobile1,
       'TransID'=>$transactioncode,
        'TransAmount'=>$amount,
       'status'=>0,
       
     ]
       
     
     );
     }
   
    return response()->json(['message' => 'Succes,Payment Created Successfully'], 200);
   }
  
   public function createpppoe()
    {
       
       $data['packages']=PppoePackages::where('status',1)->get();
   
        return view('user.createpppoe',$data);
        
        
        
    }
  public function hotspotpageconfig()
    {
       
       $data['plans']=systemSetting::where('id',0)->get();
   
        return view('user.hotspotpageconfig',$data);
        
        
        
    }
   public function hotspotpageconfigpost(Request $request)
    {
        $file=$request->file('hotspotbackground');
    $filename = $file->getClientOriginalName();
     $hotspotplancolors=$request->hotspotplancolors;
     $hotspotdesctiptionpage=$request->hotspotdesctiptionpage;
     
       $dat=systemSetting::where('id',0)->first();
     $dat->hotspotdesctiptionpage=$hotspotdesctiptionpage;
     $dat->hotspotplancolors=$hotspotplancolors;
     $dat->hotspotbackground=$filename;
     $dat->update();
     $path = public_path().'/uploads';
         $file->move($path,$filename);
        return response()->json(['message' => 'Success,Details Updated Successfuly'], 200);
        
        
        
    }
  
  
   public function createpppoestore(Request $request)
    {
        $me=\Auth::user();
     $package_id=$request->package_id;
     $name=$request->username;
     $secrete= substr(uniqid(), -8);
     $mobile=$request->mobile;
     $time=time()+(3600*24*30);
         $first_digit = $mobile[0];
  
  if($first_digit == 0){
      $mobile1 = '254'.substr($mobile,1);
  }
       if($first_digit == 7){
      $mobile1 = '254'.$mobile;
  }
       if($first_digit == "+"){
      $mobile1 = substr($mobile,1);
  }
       if($first_digit == 1){
      $mobile1 = '254'.$mobile;
  }
  
  if($first_digit == '2'){
      $mobile1 = $mobile;
  } 
    
     if($Existpppoeuser=Pppoeusers::where('username',$name)->exists())
     {
    return response()->json(['message' => 'Failed ,Please select a different username'], 200);
     }
       if($Existpppoeuser=Pppoeusers::where('mobile',$mobile1)->exists())
     {
    return response()->json(['message' => 'Failed ,Please select a different mobile number'], 200);
     }
     else{
      $Existpppoeuser=Pppoeusers::where('username',$name)->first();
       
        
       
        $storedata=Pppoeusers::create(
     [
     'username'=>$name,
       'secret'=>$secrete,
        'mobile'=>$mobile1,
       'status'=>0,
       'package_id'=>$package_id,
       'time'=>$time
     ]
       
     
     );
     
     if($storedata)
     {
        $url=$me->router_url;
            $getdata= new DetailsController;
            $user_id=$me->id;
            $routedatils=$getdata->getrouterdetails($user_id);
            $url=$routedatils->dns;
            $password=$routedatils->password;
            $username=$routedatils->name;
            $con= $getdata->createConnectionToRou($username,$password,$url);

            if($con==1){
              $childurl="$url/rest/ppp/secret";
              $mainurl=$childurl;
              
              $curl_post_data = [
            'name' => $name,
            'password' => $secrete,
            'service' =>"pppoe",
            'profile' => 'pppoe-profile',
          
           
        ];


        $payload = json_encode($curl_post_data);
            
              $getdata->putdata($mainurl,$payload,$username,$password);
            }
     }
   
      
       
     }
     
    
   
       return response()->json(['message' => 'Success,Clent Created With New Details'], 200);
        
        
        
    }
  
  
     public function transactions()
    {
        $me=\Auth::user();

              $data['plans']=Transactions::where('status',0)->get();
          
        return view('user.transactions',$data);
        
        
        
    }
    
   
    public function wifiusers()
    {
        $me=\Auth::user();

              $data['plans']=HotspotUsers::get();
          
        return view('user.wifiusers',$data);
        
        
        
    }
  
  
  public function allpppoe()
    {
        $me=\Auth::user();

              $data['plans']=Pppoeusers::get();
          
        return view('user.allpppoe',$data);
        
        
        
    }
  
  
  public function fetchPppoeUsers()
{
    // Fetch the data from the database
    $plans = Pppoeusers::all();

    // Process the plans to include package data
    foreach ($plans as $data) {
        $package = \Illuminate\Support\Facades\DB::table('PppoePackage')
                    ->where('id', $data->package_id)
                    ->first();
        $data->package_name = $package ? $package->name : 'N/A';
        $data->package_amount = $package ? $package->amount : 'N/A';
    }
    
     return response()->json($plans);
  } 
    
    
     public function fetchhotspotusers()
{
    // Fetch the data from the database
    $plans = HotspotUsers::all();

    // Process the plans to include package data
    foreach ($plans as $data) {
        $package = \Illuminate\Support\Facades\DB::table('packages')
                    ->where('id', $data->user_package)
                    ->first();
        $data->package_name = $package ? $package->package_name : 'N/A';
        $data->package_amount = $package ? $package->package_price : 'N/A';
    }

    // Return the data as JSON
    return response()->json($plans);
}
  
   public function editppoeusers(Request $request)
    {
        $me=\Auth::user();
 $data['packages']=PppoePackages::where('status',1)->get();
     $wid=$request->itemid;
              $data['plans']=Pppoeusers::where('id',$wid)->get();
          
  
     
        return view('user.editppoeusers',$data);
        
        
        
    }
   public function editppoeusersstore(Request $request)
    {
        $me=\Auth::user();
 $data['packages']=PppoePackages::where('status',1)->get();
     $wid=$request->itemid;
     $name=$request->username;
     $mobile=$request->mobile;
     $package_id=$request->package_id;
     
     $first_digit = $mobile[0];
      if($first_digit == 0){
      $mobile1 = '254'.substr($mobile,1);
  }
       if($first_digit == 7){
      $mobile1 = '254'.$mobile;
  }
       if($first_digit == "+"){
      $mobile1 = substr($mobile,1);
  }
       if($first_digit == 1){
      $mobile1 = '254'.$mobile;
  }
  
  if($first_digit == '2'){
      $mobile1 = $mobile;
  } 
     
              $dat=Pppoeusers::where('id',$wid)->first();
     $existingname=$dat->username;
     $secrete=$dat->secret;
     
     $dat->username=$name;
     $dat->mobile=$mobile1;
     $dat->package_id=$package_id;
     $dat->update();
     
     
     
      $getdata= new DetailsController;
      $user_id=$me->id;
            $routedatils=$getdata->getrouterdetails($user_id);
            $url=$routedatils->dns;
            $password=$routedatils->password;
            $username=$routedatils->name;
            $con= $getdata->createConnectionToRou($username,$password,$url);
      $data= $getdata->getdata($username,$password,"$url/rest/ppp/secret");
           
        $response= json_decode($data,true);
      
            $targetName=$existingname;
         $result = collect($response)->firstWhere('name', $targetName);
      if ($result) {
            $hostid= $result['.id'];
        
         if($con==1){
              $childurl="$url/rest/ppp/secret/$hostid";
              $mainurl=$childurl;
              
              $curl_post_data = [
            'name' => $name,
            'password' => $secrete,
            'service' =>"pppoe",
            'profile' => 'pppoe-profile',
          
           
        ];


        $payload = json_encode($curl_post_data);
            
              $getdata->putdata($mainurl,$payload,$username,$password);
            }
        }
     
          
       return response()->json(['message' => 'Success,Clent Updated With New Details'], 200);
        
        
        
    }
  
    public function activewifiusers()
    {
        $me=\Auth::user();

              $data['plans']=HotspotUsers::where('user_status',1)->get();
          
        return view('user.wifiusers',$data);
        
        
        
    }
     public function sendsinglesms()
    {
        $me=\Auth::user();

             
          
        return view('user.sendsinglesms');
        
        
        
    }
  public function sendgroupsms()
    {
        $me=\Auth::user();

             
          
        return view('user.sendgroupsms');
        
        
        
    }

    public function sendsinglesmsstore(Request $request)
    {
        $me=\Auth::user();

             
        $message=$request->message;
        $mobile=$request->mobile;
         //$message=urlencode($message);
         
      
     $curl = curl_init();
     $url="https://smsportal.hostpinnacle.co.ke/SMSApi/send?userid=endpoint&password=k8MaTzc4&mobile=$mobile&senderid=ENDPOINT&msgType=text&duplicatecheck=true&output=json&sendMethod=quick&msg=".urlencode($message);
     
     curl_setopt_array($curl, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => "",
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 30,
       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
       CURLOPT_CUSTOMREQUEST => "GET",
       CURLOPT_HTTPHEADER => array(
         "cache-control: no-cache"
       ),
     ));
     
     
     $response = curl_exec($curl);
     $err = curl_error($curl);
     
     curl_close($curl);
     
     if ($err) {
       // return $err;
     } else {
     //  return $response;
     }
     


     return back()->with('alert','Sms send successfuly');
              
        
        
        
    }
   public function sendgroupsmsstore(Request $request)
    {
        $me=\Auth::user();

             
        $message=$request->message;
        $mobile=$request->mobile;
         //$message=urlencode($message);
     $customers=$request->customers;
     
     if($customers=="activewifi"){
          $dat=HotspotUsers::where('user_status',1)->where('sms',0)->get();
     
     foreach($dat as $data)
     {
     
       $mobile=$data->user_mobile;
        $curl = curl_init();
     $url="https://smsportal.hostpinnacle.co.ke/SMSApi/send?userid=endpoint&password=k8MaTzc4&mobile=$mobile&senderid=ENDPOINT&msgType=text&duplicatecheck=true&output=json&sendMethod=quick&msg=".urlencode($message);
     
     curl_setopt_array($curl, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => "",
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 30,
       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
       CURLOPT_CUSTOMREQUEST => "GET",
       CURLOPT_HTTPHEADER => array(
         "cache-control: no-cache"
       ),
     ));
     
       
     
     $response = curl_exec($curl);
     $err = curl_error($curl);
     
     curl_close($curl);
     
     if ($err) {
       // return $err;
     } else {
     //  return $response;
     }
     
     
      
     }
     
   }
     
      if($customers=="inactivewifi"){
          $dat=HotspotUsers::where('user_status',0)->where('sms',0)->get();
     
     foreach($dat as $data)
     {
     
       $mobile=$data->user_mobile;
        $curl = curl_init();
     $url="https://smsportal.hostpinnacle.co.ke/SMSApi/send?userid=endpoint&password=k8MaTzc4&mobile=$mobile&senderid=ENDPOINT&msgType=text&duplicatecheck=true&output=json&sendMethod=quick&msg=".urlencode($message);
     
     curl_setopt_array($curl, array(
       CURLOPT_URL => $url,
       CURLOPT_RETURNTRANSFER => true,
       CURLOPT_ENCODING => "",
       CURLOPT_MAXREDIRS => 10,
       CURLOPT_TIMEOUT => 30,
       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
       CURLOPT_CUSTOMREQUEST => "GET",
       CURLOPT_HTTPHEADER => array(
         "cache-control: no-cache"
       ),
     ));
     
       
     
     $response = curl_exec($curl);
     $err = curl_error($curl);
     
     curl_close($curl);
     
     if ($err) {
       // return $err;
     } else {
     //  return $response;
     }
     
     }
      
   
     
   }

     return back()->with('alert','Sms send successfuly to Customers');
              
        
        
        
    }
    
   
   
    


    
     public function uploadtask(Request $request)
    {
        $me=\Auth::user();
            $getdata= new DetailsController;

            $con= $getdata->createConnectionToRou("admin","admin");

            $data= $getdata->getdata("admin","admin","https://192.168.88.1/rest/interface");
           
            $response = json_decode($data,true);

            foreach ($response as $item) {
                echo "ID: " . $item['.id'] . "\n";
                echo "type: " . $item['type'] . "\n";
                echo "name: " . $item['name'] . "\n";
                echo "mac-address: " . $item['mac-address'] . "\n";
               echo "fp-tx-byte: " . $item['fp-tx-byte'] . "\n";
              
            }
           // return $obj;
           
//start of investments
    }

    //router logs
    public function routerlogs(Request $request)
    {
        $me=\Auth::user();
        $url=$me->router_url;
            $getdata= new DetailsController;
            $user_id=$me->id;
            $routedatils=$getdata->getrouterdetails($user_id);
            $url=$routedatils->dns;
            $password=$routedatils->password;
            $username=$routedatils->name;
            $con= $getdata->createConnectionToRou($username,$password,$url);

            if($con==1){
                $data= $getdata->getdata("administrator","3ndP01nt@2025!#","$url/rest/log");
           
                $response= json_decode($data,true);
               
              
               return view('user.routerlogs',compact('response'));
            }
           
           else{
          return redirect()->route('noconnection')->with('alert','No connection to router');
           }
            
           
           
    }

    //mpesa payments
    
    public function mpesapayments(Request $request)
    {
        $me=\Auth::user();
            $getdata= new DetailsController;

            $data['plans']=MpesaTransaction::where('id','!=',0)->get(); 
        
           
          
           return view('user.mpesapayments',$data);
           
    } 
  
    public function dailympesapayments(Request $request)
    {
        $me=\Auth::user();
            $getdata= new DetailsController;

            $data['plans']=MpesaTransaction::where('id','!=',0)->whereDate('created_at', date('Y-m-d'))->get(); 
        
           
          
           return view('user.mpesapayments',$data);
           
    } 
  
    public function noconnection(Request $request)
    {
      
          
           return view('user.noconnection');
           
    }


    public function editpackages(Request $request)
    {
        $wid=$request->wid;
            $data['plans']=Packages::where('id',$wid)->get();
          
           return view('user.editpackages',$data);
           
    }

    public function addrouter(Request $request)
    {
      
          
           return view('user.addrouter');
           
    }
    public function allrouters(Request $request)
    {
      $data['plans']=Routers::get();
          
           return view('user.allrouters',$data);
           
    }


    public function interfaces(Request $request)
    {
        $me=\Auth::user();
      
            $getdata= new DetailsController;
           
            $user_id=$me->id;
            $routedatils=$getdata->getrouterdetails($user_id);
            $url=$routedatils->dns;
            $password=$routedatils->password;
            $username=$routedatils->name;
            $con= $getdata->createConnectionToRou($username,$password,$url);


            if($con==1){
                $data= $getdata->getdata($username,$password,"$url/rest/interface");
           
            $response= json_decode($data,true);
           
          
           return view('user.interfaces',compact('response'));
            }
           
           else{
          return redirect()->route('noconnection')->with('alert','No connection to router');
           }
           
           
    }

    public function userdetails(Request $request)
    {
        $me=\Auth::user();
        $url=$me->router_url;
            $getdata= new DetailsController;

         
          
            $con= $getdata->createConnectionToRou("admin","admin");
            if($con==1){
                $data= $getdata->getdata("admin","admin","$url/rest/ip/hotspot/host");
           
                $response= json_decode($data,true);
               
                    $adres="10.5.50.253";
                foreach($response as $data)
                {
                    if($data['address']==$adres)
                    {
                        return  $data['mac-address'];
                    }
                    else{
                                return "woiiiii";
                    }
                }
            }
           
           else{
          return redirect()->route('noconnection')->with('alert','No connection to router');
           }
           
    }



    public function editinterfaces(Request $request)
    {
        $me=\Auth::user();
        $myurl=$me->router_url;
            $getdata= new DetailsController;
           $itemid= $request->itemid;
           $user_id=$me->id;
           $routedatils=$getdata->getrouterdetails($user_id);
           $url=$routedatils->dns;
           $password=$routedatils->password;
           $username=$routedatils->name;
           $con= $getdata->createConnectionToRou($username,$password,$url);

            $url= "$url/rest/interface/$itemid";
           
          
           if($con==1){
            $data= $getdata->getdata("administrator","3ndP01nt@2025!#",$url);
           
            $response= json_decode($data,true);
           
          
           return view('user.editinterfaces',compact('response'));
         
            }
            else{
                return redirect()->route('noconnection')->with('alert','No connection to router');
              
            }
    }


    public function editinterfacesstore(Request $request)
    {
        $me=\Auth::user();
       
            $patchdata= new DetailsController;

          
          
            
            $user_id=$me->id;
            $routedatils=$patchdata->getrouterdetails($user_id);
            $url=$routedatils->dns;
            $password=$routedatils->password;
            $username=$routedatils->name;
            $con= $patchdata->createConnectionToRou($username,$password,$url);

          if($con==1){
            $itemid=$request->itemid;
            $url= "$url/rest/interface/$itemid";
           
            $data = [
                'name' =>$request->name
               
            ];
            
            $payload=json_encode($data);
                $url=$url;
                //patch data

                $name="admininistrator";
                $password="3ndP01nt@2025!#";
             $res=$patchdata->patchdata($url,$payload,$name,$password);
               
               
          return back()->with('alert',$res);
        
           }
           else{
            return redirect()->route('noconnection')->with('alert','No connection to router');
             }
    }

   

public function createuploadtask(Request $request)
{
    $me=\Auth::user();
    $password=$request->password;
     $ipormac=$request->ipormac;
     
      $validated = $request->validate([
      
        'ipormac'=>'required|max:20|min:1'
    ]);
     
        try{
       
        $con= new  DetailsController;
       $con->generatetoken($ipormac,$password);
       if($con)
       {
           return "weeeee";
       }
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}
 
public function createdpackages(Request $request)
{
    return view('user.createdpackages');
}
  
  
  public function inactive(Request $request)
{
    
   
   
     $username="administrator";
	 $password="3ndP01nt@2025!#";
         $url="http://hh50a4y4sb3.sn.mynetname.net:5890/rest/ppp/active";   
      $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL,$url);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
         curl_setopt($ch, CURLOPT_USERPWD, "$username" . ":" . "$password");
 
         $data= curl_exec($ch);
         if (curl_errno($ch)) {
             //echo 'Error:' . curl_error($ch);
             return "Request failed with status code 313";
             curl_close($ch);
         }
        
 
        
            
     
        $response= json_decode($data,true);
     
    			$targetName = "Felix pppoe";

// Use array_filter to find the matching user
$result = array_filter($response, function ($item) use ($targetName) {
    return isset($item['name']) && $item['name'] === $targetName;
});

// Convert the result to an array (if necessary) and get the first match
$result = array_values($result);

if (!empty($result)) {
    // Output the details of the found user
    $rest= $result[0];
  $myid= $rest['.id'];
  //start of deleting user from pppoe actives
   $ip= $rest['address'];
  return $ip;
  
}
   // return view('user.inactive');
}
  public function createppoepackages(Request $request)
{
    return view('user.createppoepackages');
}
 

public function allpackages(Request $request)
{
    $data['plans']=Packages::where('status',1)->get();
    return view('user.allpackages',$data);
}
  

 
public function createdpackagespost(Request $request)
{
    $me=\Auth::user();
    $package_name=$request->package_name;
     $package_price=$request->package_price;
     $package_description=$request->package_description;
     $upload_data=$request->upload_data;
     $download_data=$request->download_data;
     $time=$request->time;
     
    //   $validated = $request->validate([
      
    //     'dns'=>'required',
    //     'name'=>'required'
    // ]);
     
        try{
       $data=Packages::Create(
        [
            'package_name'=>$package_name,
            'user_id'=>$me->id,
            'package_price'=>$package_price,
            'package_description'=> $package_description,
            'upload_data'=>$upload_data,
            'download_data'=>$download_data,
            'time'=>$time,
            'status'=>1
           
        ]
        );
          return response()->json(['message' => 'Success,Plan Created Successfuly'], 200);
        
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}

  public function createppoepackagespost(Request $request)
{
    $me=\Auth::user();
    $package_name=$request->package_name;
     $package_price=$request->package_price;
     $package_description=$request->package_description;
     $upload_data=$request->upload_data;
     $download_data=$request->download_data;
     $time=$request->time;
     
    //   $validated = $request->validate([
      
    //     'dns'=>'required',
    //     'name'=>'required'
    // ]);
     
        try{
       $data=PppoePackages::Create(
        [
            'name'=>$package_name,
            
            'amount'=>$package_price,
           
            'upload'=>$upload_data,
            'download'=>$download_data,
            
            'status'=>1
           
        ]
        );
        return response()->json(['message' => 'Success,Plan Created Successfuly'], 200);
        
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}

public function getppoepackages(Request $request)
{
    $data['plans']=PppoePackages::get();
    return view('user.getppoepackages',$data);
}
 public function editppoepackages(Request $request)
    {
        $wid=$request->wid;
            $data['plans']=PppoePackages::where('id',$wid)->get();
          
           return view('user.editppoepackages',$data);
           
    }
 
  
    
    public function editppoepackagespost(Request $request)
{
    $me=\Auth::user();
    $package_name=$request->package_name;
     $package_price=$request->package_price;
     
     $upload_data=$request->upload_data;
     $download_data=$request->download_data;
     
     $wid=$request->wid;
     
    //   $validated = $request->validate([
      
    //     'dns'=>'required',
    //     'name'=>'required'
    // ]);
     
        try{
            $data=PppoePackages::where('id',$wid)->first();
       
            $data->name=$package_name;
           
            $data->amount=$package_price;
            
            $data->upload=$upload_data;
            $data->download=$download_data;
            
            $data->status=1;
           
        
        $data->update();
       return response()->json(['message' => 'Success,Plan Updated Successfuly'], 200);
        
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}
    
    
public function editpackagespost(Request $request)
{
    $me=\Auth::user();
    $package_name=$request->package_name;
     $package_price=$request->package_price;
     $package_description=$request->package_description;
     $upload_data=$request->upload_data;
     $download_data=$request->download_data;
     $time=$request->time;
     $wid=$request->wid;
     
    //   $validated = $request->validate([
      
    //     'dns'=>'required',
    //     'name'=>'required'
    // ]);
     
        try{
            $data=Packages::where('id',$wid)->first();
       
            $data->package_name=$package_name;
            $data->user_id=$me->id;
            $data->package_price=$package_price;
            $data->package_description= $package_description;
            $data->upload_data=$upload_data;
            $data->download_data=$download_data;
            $data->time=$time;
            $data->status=1;
           
        
        $data->update();
        Session::put('alert', 'Package Updated successfuly');
        return back();
        
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}

 
public function addrouterpost(Request $request)
{
    $me=\Auth::user();
    $password=$request->password;
     $dns=$request->dns;
     $name=$request->name;
     
      $validated = $request->validate([
      
        'dns'=>'required',
        'name'=>'required'
    ]);
     
        try{
       $data=Routers::Create(
        [
            'dns'=>$dns,
            'password'=>$password,
            'name'=>$name
        ]
        );
        Session::put('alert', 'Router added successfuly');
        return back();
        
        }
       catch (\Exception $e){
           //$e->getMessage()
           return back()->with('message','Oops something went wrong' );
       }
        
       
       
    
   
}
   



}