<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



Route::get('/apihome', [App\Http\Controllers\ChartApiController::class, 'ApiHome'])->name('api.chart');

Route::get('/api/pppoe-users', [App\Http\Controllers\HomeController::class, 'fetchPppoeUsers'])->name('fetchPppoeUsers');


//Route::get('/mpesa/password','MpesaController@lipaNaMpesaPassword');
Route::get('/mpesa/password', [App\Http\Controllers\MpesaController::class, 'lipaNaMpesaPassword']);
//Route::post('/mpesa/new/access/token','MpesaController@newAccessToken');
Route::post('/mpesa/new/access/token', [App\Http\Controllers\MpesaController::class, 'newAccessToken']);
//Route::post('/mpesa/stk/push','MpesaController@stkPush')->name('lipa');
Route::post('/mpesa/stk/push', [App\Http\Controllers\MpesaController::class, 'stkPush'])->name('lipa');
//Route::post('/stk/push/callback/url', 'MpesaController@MpesaRes');
Route::post('/stk/push/callback/url', [App\Http\Controllers\MpesaController::class, 'MpesaRes']);
Route::post('coinbase', [App\Http\Controllers\CoinbaseController::class, 'process']);